/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.util.EnumFacing;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileDistributor
extends TileTorqueSidedCell {
    @Override
    protected double transferPower() {
        int in = this.getPrimaryFacing().func_176734_d().ordinal();
        double out = 0.0;
        for (int i = 0; i < DIRECTION_LENGTH; ++i) {
            if (i == in) continue;
            out += this.transferPowerTo(EnumFacing.values()[i]);
        }
        return out;
    }

    @Override
    protected void balanceStorage() {
        ITorque.SidedTorqueCell out;
        int in = this.getPrimaryFacing().func_176734_d().ordinal();
        ITorque.SidedTorqueCell input = this.storage[in];
        double totalRequested = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            if (i == in) continue;
            out = this.storage[i];
            if (!this.getConnections()[i]) continue;
            totalRequested += out.getMaxEnergy() - out.getEnergy();
        }
        if (totalRequested > 0.0 && input.getEnergy() > 0.0) {
            double transfer = Math.min(totalRequested, input.getEnergy());
            double percent = transfer / totalRequested;
            double transferred = 0.0;
            for (int i = 0; i < this.storage.length; ++i) {
                if (i == in || !this.getConnections()[i]) continue;
                out = this.storage[i];
                double request = out.getMaxEnergy() - out.getEnergy();
                double trans = request * percent;
                transferred += trans;
                out.setEnergy(out.getEnergy() + trans);
            }
            input.setEnergy(input.getEnergy() - transferred);
        }
    }

    @Override
    public boolean canInputTorque(EnumFacing from) {
        return from == this.orientation.func_176734_d();
    }

    @Override
    public boolean canOutputTorque(EnumFacing from) {
        return from != this.orientation.func_176734_d();
    }
}

