/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.gamedata.MailboxData;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileMailbox
extends TileOwned
implements BlockRotationHandler.IRotatableTile,
ITickable,
IBlockBreakHandler {
    private boolean autoExport;
    private boolean privateBox;
    public ItemStackHandler sendInventory = new ItemStackHandler(18);
    public List<EnumFacing> sendSides = Lists.newArrayList();
    public ItemStackHandler receivedInventory = new ItemStackHandler(18);
    public List<EnumFacing> receivedSides = Lists.newArrayList();
    private String mailboxName;
    private String destinationName;

    public TileMailbox() {
        this.sendSides.add(EnumFacing.UP);
        this.receivedSides.add(EnumFacing.DOWN);
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mailboxName != null) {
            MailboxData data = AWGameData.INSTANCE.getData(this.field_145850_b, MailboxData.class);
            ArrayList<MailboxData.DeliverableItem> items = new ArrayList<MailboxData.DeliverableItem>();
            data.getDeliverableItems(this.privateBox ? this.getOwner().getName() : null, this.mailboxName, items, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            data.addMailboxReceiver(this.privateBox ? this.getOwner().getName() : null, this.mailboxName, this);
            if (this.destinationName != null) {
                this.trySendItems(data);
            }
        }
    }

    private void trySendItems(MailboxData data) {
        String owner = this.privateBox ? this.getOwner().getName() : null;
        int dim = this.field_145850_b.field_73011_w.getDimension();
        for (int slot = 0; slot < this.sendInventory.getSlots(); ++slot) {
            ItemStack item = this.sendInventory.getStackInSlot(slot);
            if (item.func_190926_b()) continue;
            data.addDeliverableItem(owner, this.destinationName, this.sendInventory.extractItem(slot, item.func_190916_E(), false), dim, this.field_174879_c);
            break;
        }
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public String getTargetName() {
        return this.destinationName;
    }

    public void setMailboxName(String name) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.mailboxName = name;
        this.func_70296_d();
    }

    public void setTargetName(String name) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.destinationName = name;
        this.func_70296_d();
    }

    public boolean isAutoExport() {
        return this.autoExport;
    }

    public boolean isPrivateBox() {
        return this.privateBox;
    }

    public void setAutoExport(boolean val) {
        this.autoExport = val;
    }

    public void setPrivateBox(boolean val) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (val != this.privateBox) {
            this.mailboxName = null;
            this.destinationName = null;
            this.func_70296_d();
        }
        this.privateBox = val;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int[] sides;
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetName")) {
            this.destinationName = tag.func_74779_i("targetName");
        }
        if (tag.func_74764_b("mailboxName")) {
            this.mailboxName = tag.func_74779_i("mailboxName");
        }
        if (tag.func_74764_b("sendInventory")) {
            this.sendInventory.deserializeNBT(tag.func_74775_l("sendInventory"));
        }
        if (tag.func_74764_b("receivedInventory")) {
            this.receivedInventory.deserializeNBT(tag.func_74775_l("receivedInventory"));
        }
        if (tag.func_74764_b("sendSides")) {
            sides = tag.func_74759_k("sendSides");
            this.sendSides = Arrays.stream(sides).mapToObj(o -> EnumFacing.field_82609_l[o]).collect(Collectors.toList());
        }
        if (tag.func_74764_b("receivedSides")) {
            sides = tag.func_74759_k("receivedSides");
            this.receivedSides = Arrays.stream(sides).mapToObj(o -> EnumFacing.field_82609_l[o]).collect(Collectors.toList());
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.destinationName != null) {
            tag.func_74778_a("targetName", this.destinationName);
        }
        if (this.mailboxName != null) {
            tag.func_74778_a("mailboxName", this.mailboxName);
        }
        tag.func_74782_a("sendInventory", (NBTBase)this.sendInventory.serializeNBT());
        tag.func_74782_a("receivedInventory", (NBTBase)this.receivedInventory.serializeNBT());
        tag.func_74783_a("sendSides", this.sendSides.stream().mapToInt(Enum::ordinal).toArray());
        tag.func_74783_a("receivedSides", this.receivedSides.stream().mapToInt(Enum::ordinal).toArray());
        return tag;
    }

    @Override
    public EnumFacing getPrimaryFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CoreProperties.FACING);
    }

    @Override
    public void setPrimaryFacing(EnumFacing face) {
        this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)CoreProperties.FACING, (Comparable)face), 0);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (this.sendSides.contains(facing) || this.receivedSides.contains(facing)) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.receivedSides.contains(facing)) {
                return (T)this.receivedInventory;
            }
            if (this.sendSides.contains(facing)) {
                return (T)this.sendInventory;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onBlockBroken() {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.sendInventory, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.receivedInventory, this.field_174879_c);
    }
}

