/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCRenderState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.render.ITESRRenderer;

public abstract class BaseAnimationRenderer<T extends TileEntity>
extends FastTESR<T> {
    private final ITESRRenderer bakery;

    public BaseAnimationRenderer(ITESRRenderer bakery) {
        this.bakery = bakery;
    }

    public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder renderer) {
        BlockPos pos = te.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)te.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            exState = this.handleState(te, partialTicks, exState);
            renderer.func_178969_c(x, y, z);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind(renderer);
            ccrs.setBrightness((IBlockAccess)world, pos);
            this.bakery.renderTransformedBlockModels(ccrs, exState);
        }
    }

    protected abstract IExtendedBlockState handleState(T var1, float var2, IExtendedBlockState var3);
}

