/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.item;

import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.AncientWarfareAutomation;
import net.shadowmage.ancientwarfare.automation.init.AWAutomationItems;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.item.ItemMulti;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ItemWorksiteUpgrade
extends ItemMulti {
    public ItemWorksiteUpgrade() {
        super("ancientwarfareautomation", "worksite_upgrade");
        this.func_77637_a(AncientWarfareAutomation.TAB);
    }

    private static WorksiteUpgrade getUpgrade(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != AWAutomationItems.WORKSITE_UPGRADE) {
            throw new RuntimeException("Cannot retrieve worksite upgrade type for: " + stack + ".  Null stack, or item, or mismatched item!");
        }
        return WorksiteUpgrade.values()[stack.func_77952_i()];
    }

    public static ItemStack getStack(WorksiteUpgrade upgrade) {
        return upgrade == null ? ItemStack.field_190927_a : new ItemStack((Item)AWAutomationItems.WORKSITE_UPGRADE, 1, upgrade.ordinal());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        BlockPos pos = BlockTools.getBlockClickedOn(player, world, false);
        if (pos != null && (te = world.func_175625_s(pos)) instanceof IWorkSite) {
            IWorkSite ws = (IWorkSite)te;
            WorksiteUpgrade upgrade = ItemWorksiteUpgrade.getUpgrade(stack);
            if (!ws.getValidUpgrades().contains((Object)upgrade)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            HashSet<WorksiteUpgrade> wsug = new HashSet<WorksiteUpgrade>(ws.getUpgrades());
            if (wsug.contains((Object)upgrade)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            for (WorksiteUpgrade ug : wsug) {
                if (!ug.exclusive(upgrade)) continue;
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            for (WorksiteUpgrade ug : wsug) {
                if (!upgrade.overrides(ug)) continue;
                InventoryTools.dropItemInWorld(player.field_70170_p, ItemWorksiteUpgrade.getStack(ug), te.func_174877_v());
                ws.removeUpgrade(ug);
            }
            ws.addUpgrade(upgrade);
            stack.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

