/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseInterface;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseInterfaceFilter;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;

public class GuiWarehouseInterface
extends GuiContainerBase<ContainerWarehouseInterface> {
    private CompositeScrolled area;

    public GuiWarehouseInterface(ContainerBase par1Container) {
        super(par1Container, 178, 240);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, this.field_146999_f, 88);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        Button button;
        this.area.clearElements();
        int totalHeight = 8;
        for (WarehouseInterfaceFilter filter : ((ContainerWarehouseInterface)((Object)this.getContainer())).filters) {
            FilterItemSlot slot = new FilterItemSlot(8, totalHeight, filter, this);
            this.area.addGuiElement(slot);
            FilterQuantityInput input = new FilterQuantityInput(38, totalHeight + 3, filter);
            input.setIntegerValue();
            this.area.addGuiElement(input);
            button = new FilterRemoveButton(this.field_146999_f - 16 - 12, totalHeight + 3, filter);
            this.area.addGuiElement(button);
            totalHeight += 18;
        }
        if (((ContainerWarehouseInterface)((Object)this.getContainer())).filters.size() < 9) {
            button = new Button(8, totalHeight, 95, 12, "guistrings.automation.new_filter"){

                @Override
                protected void onPressed() {
                    WarehouseInterfaceFilter filter = new WarehouseInterfaceFilter();
                    filter.setFilterQuantity(64);
                    ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).filters.add(filter);
                    ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).sendFiltersToServer();
                    GuiWarehouseInterface.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    private class FilterItemSlot
    extends ItemSlot {
        WarehouseInterfaceFilter filter;

        public FilterItemSlot(int topLeftX, int topLeftY, WarehouseInterfaceFilter filter, ITooltipRenderer render) {
            super(topLeftX, topLeftY, filter.getFilterItem(), render);
            this.filter = filter;
            this.setRenderItemQuantity(false);
        }

        @Override
        public void onSlotClicked(ItemStack stack, boolean rightClicked) {
            ItemStack in = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            this.setItem(in);
            if (!in.func_190926_b()) {
                in.func_190920_e(1);
            }
            this.filter.setFilterQuantity(0);
            this.filter.setFilterItem(in.func_190926_b() ? ItemStack.field_190927_a : in.func_77946_l());
            ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).sendFiltersToServer();
        }
    }

    private class FilterQuantityInput
    extends NumberInput {
        WarehouseInterfaceFilter filter;

        public FilterQuantityInput(int topLeftX, int topLeftY, WarehouseInterfaceFilter filter) {
            super(topLeftX, topLeftY, 40, filter.getFilterQuantity(), (IWidgetSelection)GuiWarehouseInterface.this);
            this.filter = filter;
        }

        @Override
        public void onValueUpdated(float value) {
            this.filter.setFilterQuantity((int)value);
            GuiWarehouseInterface.this.refreshGui();
            ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).sendFiltersToServer();
        }
    }

    private class FilterRemoveButton
    extends Button {
        WarehouseInterfaceFilter filter;

        public FilterRemoveButton(int topLeftX, int topLeftY, WarehouseInterfaceFilter filter) {
            super(topLeftX, topLeftY, 12, 12, "-");
            this.filter = filter;
        }

        @Override
        protected void onPressed() {
            ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).filters.remove(this.filter);
            ((ContainerWarehouseInterface)((Object)GuiWarehouseInterface.this.getContainer())).sendFiltersToServer();
            GuiWarehouseInterface.this.refreshGui();
        }
    }
}

