/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gamedata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.automation.tile.TileMailbox;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.Trig;

public class MailboxData
extends WorldSavedData {
    private MailboxSet publicMailboxes = new MailboxSet("public");
    private HashMap<String, MailboxSet> privateMailboxes = new HashMap();

    public MailboxData(String par1Str) {
        super(par1Str);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            this.onTick(1);
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.publicMailboxes = new MailboxSet("public");
        this.publicMailboxes.readFromNBT(tag.func_74775_l("publicBoxes"));
        NBTTagList privateBoxList = tag.func_150295_c("privateBoxes", 10);
        this.privateMailboxes.clear();
        for (int i = 0; i < privateBoxList.func_74745_c(); ++i) {
            MailboxSet boxSet = new MailboxSet();
            boxSet.readFromNBT(privateBoxList.func_150305_b(i));
            this.privateMailboxes.put(boxSet.owningPlayerName, boxSet);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74782_a("publicBoxes", (NBTBase)this.publicMailboxes.writeToNBT(new NBTTagCompound()));
        NBTTagList privateBoxList = new NBTTagList();
        for (MailboxSet set : this.privateMailboxes.values()) {
            privateBoxList.func_74742_a((NBTBase)set.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("privateBoxes", (NBTBase)privateBoxList);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick(int length) {
        boolean change;
        Object object = this.publicMailboxes;
        synchronized (object) {
            change = this.publicMailboxes.tick(length);
            if (change) {
                this.func_76185_a();
            }
        }
        object = this.privateMailboxes;
        synchronized (object) {
            change = false;
            for (MailboxSet set : this.privateMailboxes.values()) {
                change |= set.tick(length);
            }
            if (change) {
                this.func_76185_a();
            }
        }
    }

    public boolean addMailbox(@Nullable String owner, String name) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        this.func_76185_a();
        return set.addMailbox(name);
    }

    public boolean deleteMailbox(@Nullable String owner, String name) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        this.func_76185_a();
        return set.deleteMailbox(name);
    }

    public void addDeliverableItem(@Nullable String owner, String name, ItemStack item, int dim, BlockPos pos) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        MailboxEntry entry = set.getOrCreateMailbox(name);
        entry.addDeliverableItem(item, dim, pos);
        this.func_76185_a();
    }

    private MailboxSet getOrCreatePrivateMailbox(@Nullable String owner) {
        if (owner == null) {
            owner = "";
        }
        if (!this.privateMailboxes.containsKey(owner)) {
            this.privateMailboxes.put(owner, new MailboxSet(owner));
            this.func_76185_a();
        }
        return this.privateMailboxes.get(owner);
    }

    public List<String> getPublicBoxNames() {
        ArrayList<String> names = new ArrayList<String>();
        MailboxSet set = this.publicMailboxes;
        names.addAll(set.mailboxes.keySet());
        return names;
    }

    public List<String> getPrivateBoxNames(String owner) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.privateMailboxes.containsKey(owner)) {
            names.addAll(this.privateMailboxes.get(owner).mailboxes.keySet());
        }
        return names;
    }

    public List<DeliverableItem> getDeliverableItems(@Nullable String owner, String name, List<DeliverableItem> items, World world, int x, int y, int z) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        return set.getDeliverableItems(name, items, world, x, y, z);
    }

    public void removeDeliverableItem(@Nullable String owner, String name, DeliverableItem item) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        set.removeDeliverableItem(name, item);
        this.func_76185_a();
    }

    public void addMailboxReceiver(@Nullable String owner, String name, TileMailbox box) {
        MailboxSet set = owner == null ? this.publicMailboxes : this.getOrCreatePrivateMailbox(owner);
        set.addReceiver(name, box);
        this.func_76185_a();
    }

    public final class DeliverableItem {
        int originDimension;
        int x;
        int y;
        int z;
        @Nonnull
        public ItemStack item;
        int deliveryTime;

        private DeliverableItem(ItemStack item, int dim, int x, int y, int z) {
            this.item = item;
            this.originDimension = dim;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private DeliverableItem() {
        }

        private void readFromNBT(NBTTagCompound tag) {
            this.item = new ItemStack(tag.func_74775_l("item"));
            this.deliveryTime = tag.func_74762_e("time");
            this.originDimension = tag.func_74762_e("dim");
            this.x = tag.func_74762_e("x");
            this.y = tag.func_74762_e("y");
            this.z = tag.func_74762_e("z");
        }

        private NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("item", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            tag.func_74768_a("time", this.deliveryTime);
            tag.func_74768_a("dim", this.originDimension);
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("y", this.y);
            tag.func_74768_a("z", this.z);
            return tag;
        }

        private void tick(int length) {
            this.deliveryTime += length;
        }
    }

    public final class MailboxEntry {
        private String mailboxName;
        private List<DeliverableItem> incomingItems = new ArrayList<DeliverableItem>();
        private List<TileMailbox> receivers = new ArrayList<TileMailbox>();

        private MailboxEntry(String name) {
            this.mailboxName = name;
        }

        private MailboxEntry() {
        }

        private void addReceiver(TileMailbox tile) {
            this.receivers.add(tile);
        }

        private void removeDeliverableItem(DeliverableItem item) {
            this.incomingItems.remove(item);
        }

        private List<DeliverableItem> getDeliverableItems(List<DeliverableItem> items, World world, int x, int y, int z) {
            int dim = world.field_73011_w.getDimension();
            int time = 0;
            int timePerBlock = 10;
            int timeForDimension = 100;
            for (DeliverableItem item : this.incomingItems) {
                if (dim != item.originDimension) {
                    time = timeForDimension;
                } else {
                    float dist = Trig.getDistance(item.x, item.y, item.z, x, y, z);
                    time = (int)(dist * (float)timePerBlock);
                }
                if (item.deliveryTime < time) continue;
                items.add(item);
            }
            return items;
        }

        private void addDeliverableItem(ItemStack item, int dimension, BlockPos pos) {
            DeliverableItem item1 = new DeliverableItem(item, dimension, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.incomingItems.add(item1);
        }

        private void readFromNBT(NBTTagCompound tag) {
            this.mailboxName = tag.func_74779_i("name");
            NBTTagList itemList = tag.func_150295_c("itemList", 10);
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemList.func_150305_b(i);
                DeliverableItem item = new DeliverableItem();
                item.readFromNBT(itemTag);
                this.incomingItems.add(item);
            }
        }

        private NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("name", this.mailboxName);
            NBTTagList itemList = new NBTTagList();
            for (DeliverableItem item : this.incomingItems) {
                NBTTagCompound itemTag = item.writeToNBT(new NBTTagCompound());
                itemList.func_74742_a((NBTBase)itemTag);
            }
            tag.func_74782_a("itemList", (NBTBase)itemList);
            return tag;
        }

        private boolean tick(int length) {
            boolean ret = this.incomingItems.size() > 0;
            for (DeliverableItem item : this.incomingItems) {
                item.tick(length);
            }
            int time = 0;
            int timePerBlock = 10;
            int timeForDimension = 100;
            block1: for (TileMailbox box : this.receivers) {
                DeliverableItem item;
                int dim = box.func_145831_w().field_73011_w.getDimension();
                int x = box.func_174877_v().func_177958_n();
                int y = box.func_174877_v().func_177956_o();
                int z = box.func_174877_v().func_177952_p();
                Iterator<DeliverableItem> it = this.incomingItems.iterator();
                while (it.hasNext() && (item = it.next()) != null) {
                    if (dim != item.originDimension) {
                        time = timeForDimension;
                    } else {
                        float dist = Trig.getDistance(item.x, item.y, item.z, x, y, z);
                        time = (int)(dist * (float)timePerBlock);
                    }
                    if (item.deliveryTime < time) continue;
                    ItemStack stack = InventoryTools.mergeItemStack((IItemHandler)box.receivedInventory, item.item);
                    if (!stack.func_190926_b()) continue block1;
                    it.remove();
                    continue block1;
                }
            }
            this.receivers.clear();
            return ret;
        }

        public String toString() {
            return "MailboxEntry: " + MailboxData.this.field_76190_i + " Items List: " + this.incomingItems;
        }
    }

    private final class MailboxSet {
        private String owningPlayerName;
        private HashMap<String, MailboxEntry> mailboxes = new HashMap();

        private MailboxSet(String name) {
            this.owningPlayerName = name;
        }

        private MailboxSet() {
        }

        private boolean addMailbox(String name) {
            if (this.mailboxes.containsKey(name)) {
                return false;
            }
            this.mailboxes.put(name, new MailboxEntry(name));
            return true;
        }

        private boolean deleteMailbox(String name) {
            if (!this.mailboxes.containsKey(name)) {
                return false;
            }
            if (!this.mailboxes.get(name).incomingItems.isEmpty()) {
                return false;
            }
            this.mailboxes.remove(name);
            return true;
        }

        private void readFromNBT(NBTTagCompound tag) {
            NBTTagList mailboxList = tag.func_150295_c("mailboxList", 10);
            this.mailboxes.clear();
            for (int i = 0; i < mailboxList.func_74745_c(); ++i) {
                NBTTagCompound mailboxTag = mailboxList.func_150305_b(i);
                MailboxEntry entry = new MailboxEntry();
                entry.readFromNBT(mailboxTag);
                this.mailboxes.put(entry.mailboxName, entry);
            }
            this.owningPlayerName = tag.func_74779_i("ownerName");
        }

        private NBTTagCompound writeToNBT(NBTTagCompound tag) {
            NBTTagList mailboxList = new NBTTagList();
            for (MailboxEntry entry : this.mailboxes.values()) {
                NBTTagCompound mailboxTag = entry.writeToNBT(new NBTTagCompound());
                mailboxList.func_74742_a((NBTBase)mailboxTag);
            }
            tag.func_74782_a("mailboxList", (NBTBase)mailboxList);
            tag.func_74778_a("ownerName", this.owningPlayerName);
            return tag;
        }

        private boolean tick(int length) {
            boolean ret = false;
            for (MailboxEntry entry : this.mailboxes.values()) {
                ret |= entry.tick(length);
            }
            return ret;
        }

        private MailboxEntry getOrCreateMailbox(String name) {
            if (!this.mailboxes.containsKey(name)) {
                this.mailboxes.put(name, new MailboxEntry(name));
            }
            return this.mailboxes.get(name);
        }

        private List<DeliverableItem> getDeliverableItems(String name, List<DeliverableItem> items, World world, int x, int y, int z) {
            if (this.mailboxes.containsKey(name)) {
                return this.mailboxes.get(name).getDeliverableItems(items, world, x, y, z);
            }
            return Collections.emptyList();
        }

        private void removeDeliverableItem(String name, DeliverableItem item) {
            if (this.mailboxes.containsKey(name)) {
                this.mailboxes.get(name).removeDeliverableItem(item);
            }
        }

        private void addReceiver(String name, TileMailbox box) {
            if (this.mailboxes.containsKey(name)) {
                this.mailboxes.get(name).addReceiver(box);
            }
        }
    }
}

