/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.automation.gamedata.MailboxData;
import net.shadowmage.ancientwarfare.automation.tile.TileMailbox;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import org.apache.commons.lang3.StringUtils;

public class ContainerMailbox
extends ContainerTileBase<TileMailbox> {
    public int guiHeight;
    public String targetName;
    public String mailboxName;
    public boolean autoExport;
    public boolean privateBox;
    public List<String> publicBoxNames = Lists.newArrayList();
    public List<String> privateBoxNames = Lists.newArrayList();
    public List<EnumFacing> sendSides = Lists.newArrayList();
    public List<EnumFacing> receivedSides = Lists.newArrayList();

    public ContainerMailbox(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        int yPos;
        int xPos;
        int y1;
        int x1;
        int i;
        for (i = 0; i < 18; ++i) {
            x1 = i % 9;
            y1 = i / 9;
            xPos = x1 * 18 + 8;
            yPos = y1 * 18 + 8 + 12;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((TileMailbox)this.tileEntity).receivedInventory, i, xPos, yPos){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return false;
                }
            });
        }
        for (i = 0; i < 18; ++i) {
            x1 = i % 9;
            y1 = i / 9;
            xPos = x1 * 18 + 8;
            yPos = y1 * 18 + 8 + 12 + 36 + 12;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)((TileMailbox)this.tileEntity).sendInventory, i, xPos, yPos));
        }
        y1 = 104;
        this.guiHeight = this.addPlayerSlots(y1 + 12) + 8 + 24;
        if (!player.field_70170_p.field_72995_K) {
            MailboxData data = AWGameData.INSTANCE.getData(player.field_70170_p, MailboxData.class);
            this.publicBoxNames.addAll(data.getPublicBoxNames());
            this.privateBoxNames.addAll(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwner().getName()));
            this.privateBox = ((TileMailbox)this.tileEntity).isPrivateBox();
            this.autoExport = ((TileMailbox)this.tileEntity).isAutoExport();
            this.mailboxName = ((TileMailbox)this.tileEntity).getMailboxName();
            this.targetName = ((TileMailbox)this.tileEntity).getTargetName();
            this.sendSides = ((TileMailbox)this.tileEntity).sendSides;
            this.receivedSides = ((TileMailbox)this.tileEntity).receivedSides;
        }
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("sendSides", ((TileMailbox)this.tileEntity).sendSides.stream().mapToInt(Enum::ordinal).toArray());
        tag.func_74783_a("receivedSides", ((TileMailbox)this.tileEntity).receivedSides.stream().mapToInt(Enum::ordinal).toArray());
        if (this.mailboxName != null) {
            tag.func_74778_a("mailboxName", this.mailboxName);
        }
        if (this.targetName != null) {
            tag.func_74778_a("targetName", this.targetName);
        }
        tag.func_74757_a("privateBox", this.privateBox);
        tag.func_74757_a("autoExport", this.autoExport);
        NBTTagList nameList = new NBTTagList();
        for (String boxName : this.publicBoxNames) {
            nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
        }
        tag.func_74782_a("publicBoxNames", (NBTBase)nameList);
        nameList = new NBTTagList();
        for (String boxName : this.privateBoxNames) {
            nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
        }
        tag.func_74782_a("privateBoxNames", (NBTBase)nameList);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        int i;
        NBTTagList nameList;
        int[] sides;
        this.handleAccessChange(tag);
        if (tag.func_74764_b("sendSides")) {
            sides = tag.func_74759_k("sendSides");
            ((TileMailbox)this.tileEntity).sendSides = Arrays.stream(sides).mapToObj(o -> EnumFacing.field_82609_l[o]).collect(Collectors.toList());
            this.sendSides = ((TileMailbox)this.tileEntity).sendSides;
        }
        if (tag.func_74764_b("receivedSides")) {
            sides = tag.func_74759_k("receivedSides");
            ((TileMailbox)this.tileEntity).receivedSides = Arrays.stream(sides).mapToObj(o -> EnumFacing.field_82609_l[o]).collect(Collectors.toList());
            this.receivedSides = ((TileMailbox)this.tileEntity).receivedSides;
        }
        if (tag.func_74764_b("autoExport")) {
            this.autoExport = tag.func_74767_n("autoExport");
            ((TileMailbox)this.tileEntity).setAutoExport(this.autoExport);
        }
        if (tag.func_74764_b("privateBox")) {
            this.privateBox = tag.func_74767_n("privateBox");
            ((TileMailbox)this.tileEntity).setPrivateBox(this.privateBox);
        }
        if (tag.func_74764_b("clearMailbox")) {
            this.mailboxName = null;
            ((TileMailbox)this.tileEntity).setMailboxName(null);
        } else if (tag.func_74764_b("mailboxName")) {
            this.mailboxName = tag.func_74779_i("mailboxName");
            ((TileMailbox)this.tileEntity).setMailboxName(this.mailboxName);
        }
        if (tag.func_74764_b("clearTarget")) {
            this.targetName = null;
            ((TileMailbox)this.tileEntity).setTargetName(null);
        } else if (tag.func_74764_b("targetName")) {
            this.targetName = tag.func_74779_i("targetName");
            ((TileMailbox)this.tileEntity).setTargetName(this.targetName);
        }
        if (tag.func_74764_b("publicBoxNames")) {
            this.publicBoxNames.clear();
            nameList = tag.func_150295_c("publicBoxNames", 8);
            for (i = 0; i < nameList.func_74745_c(); ++i) {
                this.publicBoxNames.add(nameList.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("privateBoxNames")) {
            this.privateBoxNames.clear();
            nameList = tag.func_150295_c("privateBoxNames", 8);
            for (i = 0; i < nameList.func_74745_c(); ++i) {
                this.privateBoxNames.add(nameList.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("addMailbox") || tag.func_74764_b("deleteMailbox")) {
            MailboxData data = AWGameData.INSTANCE.getData(this.player.field_70170_p, MailboxData.class);
            String name = tag.func_74779_i("addMailbox");
            if (!name.isEmpty()) {
                data.addMailbox(((TileMailbox)this.tileEntity).isPrivateBox() ? ((TileMailbox)this.tileEntity).getOwner().getName() : null, name);
            }
            if (!(name = tag.func_74779_i("deleteMailbox")).isEmpty()) {
                data.deleteMailbox(((TileMailbox)this.tileEntity).isPrivateBox() ? ((TileMailbox)this.tileEntity).getOwner().getName() : null, name);
            }
        }
        this.refreshGui();
    }

    private void handleAccessChange(NBTTagCompound tag) {
        if (tag.func_74764_b("accessChange")) {
            NBTTagCompound slotTag = tag.func_74775_l("accessChange");
            BlockRotationHandler.RelativeSide base = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("baseSide")];
            BlockRotationHandler.RelativeSide access = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("accessSide")];
            this.updateSides(base, access);
        }
    }

    public void updateSides(BlockRotationHandler.RelativeSide base, BlockRotationHandler.RelativeSide access) {
        EnumFacing facing = BlockRotationHandler.RelativeSide.getMCSideToAccess(BlockRotationHandler.RotationType.FOUR_WAY, ((TileMailbox)this.tileEntity).getPrimaryFacing(), base);
        if (access == BlockRotationHandler.RelativeSide.TOP || access == BlockRotationHandler.RelativeSide.BOTTOM) {
            List<EnumFacing> addTo;
            List<EnumFacing> removeFrom;
            if (access == BlockRotationHandler.RelativeSide.TOP) {
                removeFrom = ((TileMailbox)this.tileEntity).sendSides;
                addTo = ((TileMailbox)this.tileEntity).receivedSides;
            } else {
                removeFrom = ((TileMailbox)this.tileEntity).receivedSides;
                addTo = ((TileMailbox)this.tileEntity).sendSides;
            }
            removeFrom.remove(facing);
            addTo.add(facing);
        } else {
            ((TileMailbox)this.tileEntity).sendSides.remove(facing);
            ((TileMailbox)this.tileEntity).receivedSides.remove(facing);
        }
        this.sendSides = ((TileMailbox)this.tileEntity).sendSides;
        this.receivedSides = ((TileMailbox)this.tileEntity).receivedSides;
    }

    public void sendSlotChange(BlockRotationHandler.RelativeSide base, BlockRotationHandler.RelativeSide access) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound slotTag = new NBTTagCompound();
        slotTag.func_74768_a("baseSide", base.ordinal());
        slotTag.func_74768_a("accessSide", access.ordinal());
        tag.func_74782_a("accessChange", (NBTBase)slotTag);
        this.sendDataToServer(tag);
    }

    public void func_75142_b() {
        NBTTagList nameList;
        MailboxData data;
        String name;
        super.func_75142_b();
        NBTTagCompound tag = null;
        if (!this.sendSides.equals(((TileMailbox)this.tileEntity).sendSides)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.sendSides = ((TileMailbox)this.tileEntity).sendSides;
            tag.func_74783_a("sendSides", this.sendSides.stream().mapToInt(Enum::ordinal).toArray());
        }
        if (!this.receivedSides.equals(((TileMailbox)this.tileEntity).receivedSides)) {
            this.receivedSides = ((TileMailbox)this.tileEntity).receivedSides;
            tag.func_74783_a("receivedSides", this.receivedSides.stream().mapToInt(Enum::ordinal).toArray());
        }
        if (!StringUtils.equals((CharSequence)(name = ((TileMailbox)this.tileEntity).getMailboxName()), (CharSequence)this.mailboxName)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.mailboxName = ((TileMailbox)this.tileEntity).getMailboxName();
            if (this.mailboxName == null) {
                tag.func_74757_a("clearMailbox", true);
            } else {
                tag.func_74778_a("mailboxName", this.mailboxName);
            }
        }
        if (!StringUtils.equals((CharSequence)(name = ((TileMailbox)this.tileEntity).getTargetName()), (CharSequence)this.targetName)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.targetName = ((TileMailbox)this.tileEntity).getTargetName();
            if (this.targetName == null) {
                tag.func_74757_a("clearTarget", true);
            } else {
                tag.func_74778_a("targetName", this.targetName);
            }
        }
        if (this.autoExport != ((TileMailbox)this.tileEntity).isAutoExport()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.autoExport = ((TileMailbox)this.tileEntity).isAutoExport();
            tag.func_74757_a("autoExport", this.autoExport);
        }
        if (this.privateBox != ((TileMailbox)this.tileEntity).isPrivateBox()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.privateBox = ((TileMailbox)this.tileEntity).isPrivateBox();
            tag.func_74757_a("privateBox", this.privateBox);
        }
        if (!this.publicBoxNames.equals((data = AWGameData.INSTANCE.getData(this.player.field_70170_p, MailboxData.class)).getPublicBoxNames())) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.publicBoxNames.clear();
            this.publicBoxNames.addAll(data.getPublicBoxNames());
            nameList = new NBTTagList();
            for (String boxName : this.publicBoxNames) {
                nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
            }
            tag.func_74782_a("publicBoxNames", (NBTBase)nameList);
        }
        if (!this.privateBoxNames.equals(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwner().getName()))) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.privateBoxNames.clear();
            this.privateBoxNames.addAll(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwner().getName()));
            nameList = new NBTTagList();
            for (String boxName : this.privateBoxNames) {
                nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
            }
            tag.func_74782_a("privateBoxNames", (NBTBase)nameList);
        }
        if (tag != null) {
            this.sendDataToClient(tag);
        }
    }

    public void handleNameAdd(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("addMailbox", name);
        this.sendDataToServer(tag);
    }

    public void handleNameDelete(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("deleteMailbox", name);
        this.sendDataToServer(tag);
    }

    public void handleNameSelection(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        if (name == null) {
            tag.func_74757_a("clearMailbox", true);
        } else {
            tag.func_74778_a("mailboxName", name);
        }
        this.mailboxName = name;
        this.sendDataToServer(tag);
    }

    public void handleTargetSelection(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        if (name == null) {
            tag.func_74757_a("clearTarget", true);
        } else {
            tag.func_74778_a("targetName", name);
        }
        this.targetName = name;
        this.sendDataToServer(tag);
    }

    public void handlePrivateBoxToggle(boolean newVal) {
        this.targetName = null;
        this.mailboxName = null;
        this.privateBox = newVal;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("privateBox", this.privateBox);
        this.sendDataToServer(tag);
    }

    public void handleAutoExportToggle(boolean newVal) {
        this.autoExport = newVal;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("autoExport", newVal);
        this.sendDataToServer(tag);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }
}

