/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockWorksiteBase
extends BlockBaseAutomation
implements BlockRotationHandler.IRotatableBlock {
    private static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private Supplier<TileEntity> tileFactory;

    public BlockWorksiteBase(String regName) {
        super(Material.field_151575_d, regName);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, ACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return WorldTools.getTile(world, pos, BlockRotationHandler.IRotatableTile.class).map(t -> state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)t.getPrimaryFacing()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(t instanceof TileWorksiteBase && ((TileWorksiteBase)t).isActive()))).orElse(state);
    }

    public BlockWorksiteBase setTileFactory(Supplier<TileEntity> renderFactory) {
        this.tileFactory = renderFactory;
        return this;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.tileFactory.get();
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileFactory != null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInteractableTile) {
            boolean canClick = false;
            if (te instanceof IOwnable && ((IOwnable)te).isOwner(player)) {
                canClick = true;
            } else if (te instanceof IWorkSite && ((IWorkSite)te).getOwner().isOwnerOrSameTeamOrFriend((Entity)player)) {
                canClick = true;
            }
            if (canClick) {
                return ((IInteractableTile)te).onBlockClicked(player, hand);
            }
        }
        return false;
    }

    @Override
    public final BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    public final boolean rotateBlock(World world, BlockPos pos, EnumFacing facing) {
        Optional<BlockRotationHandler.IRotatableTile> te;
        if ((facing == EnumFacing.DOWN || facing == EnumFacing.UP) && (te = WorldTools.getTile((IBlockAccess)world, pos, BlockRotationHandler.IRotatableTile.class)).isPresent()) {
            if (!world.field_72995_K) {
                this.rotateTile(facing, te.get());
            }
            return true;
        }
        return false;
    }

    private void rotateTile(EnumFacing facing, BlockRotationHandler.IRotatableTile te) {
        EnumFacing o = te.getPrimaryFacing().func_176732_a(facing.func_176740_k());
        te.setPrimaryFacing(o);
    }

    public final EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }
}

