/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockTorqueTransport;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.TorqueShaftRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaft;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaftHeavy;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaftLight;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaftMedium;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockTorqueTransportShaft
extends BlockTorqueTransport
implements IBakeryProvider {
    public static final IUnlistedProperty<Boolean> HAS_PREVIOUS = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"has_previous"));
    public static final IUnlistedProperty<Boolean> HAS_NEXT = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"has_next"));

    public BlockTorqueTransportShaft(String regName) {
        super(regName);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))) {
            case LIGHT: {
                return new TileTorqueShaftLight();
            }
            case MEDIUM: {
                return new TileTorqueShaftMedium();
            }
            case HEAVY: {
                return new TileTorqueShaftHeavy();
            }
        }
        return new TileTorqueShaftLight();
    }

    @Override
    protected void addProperties(BlockStateContainer.Builder builder) {
        super.addProperties(builder);
        builder.add(new IUnlistedProperty[]{HAS_PREVIOUS, HAS_NEXT, AutomationProperties.USE_INPUT, AutomationProperties.INPUT_ROTATION});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TorqueShaftRenderer.INSTANCE.handleState((IExtendedBlockState)state, world, pos);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float min = 0.1875f;
        float max = 0.8125f;
        float x1 = min;
        float y1 = min;
        float z1 = min;
        float x2 = max;
        float y2 = max;
        float z2 = max;
        Optional<TileTorqueShaft> te = WorldTools.getTile(world, pos, TileTorqueShaft.class);
        if (te.isPresent()) {
            TileTorqueShaft tile = te.get();
            EnumFacing facing = tile.getPrimaryFacing();
            switch (facing.func_176740_k()) {
                case X: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    break;
                }
                case Y: {
                    y1 = 0.0f;
                    y2 = 1.0f;
                    break;
                }
                case Z: {
                    z1 = 0.0f;
                    z2 = 1.0f;
                }
            }
        }
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoaderHelper.registerItem(this, "automation", "light", false);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(new IProperty[]{AutomationProperties.TIER}).addKeyProperties(CoreProperties.UNLISTED_FACING, AutomationProperties.DYNAMIC, HAS_PREVIOUS, HAS_NEXT).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.INPUT_ROTATION).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.ROTATIONS).build());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                switch ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))) {
                    case LIGHT: {
                        return TorqueShaftRenderer.LIGHT_MODEL_LOCATION;
                    }
                    case MEDIUM: {
                        return TorqueShaftRenderer.MEDIUM_MODEL_LOCATION;
                    }
                }
                return TorqueShaftRenderer.HEAVY_MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)TorqueShaftRenderer.LIGHT_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return TorqueShaftRenderer.INSTANCE.getSprite(TorqueTier.LIGHT);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)TorqueShaftRenderer.MEDIUM_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return TorqueShaftRenderer.INSTANCE.getSprite(TorqueTier.MEDIUM);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)TorqueShaftRenderer.HEAVY_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return TorqueShaftRenderer.INSTANCE.getSprite(TorqueTier.HEAVY);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return TorqueShaftRenderer.INSTANCE;
    }
}

