/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.block.BlockTorqueBase;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class BlockTorqueTransport
extends BlockTorqueBase {
    protected BlockTorqueTransport(String regName) {
        super(Material.field_151576_e, regName);
        this.func_149713_g(1);
    }

    @Override
    protected void addProperties(BlockStateContainer.Builder builder) {
        builder.add(new IProperty[]{AutomationProperties.TIER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AutomationProperties.TIER, (Comparable)((Object)TorqueTier.byMetadata(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))).getMeta();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(placer.func_184586_b(hand).func_77960_j());
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 2));
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.SIX_WAY;
    }

    @Override
    public boolean invertFacing() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float min = 0.1875f;
        float max = 0.8125f;
        float x1 = min;
        float y1 = min;
        float z1 = min;
        float x2 = max;
        float y2 = max;
        float z2 = max;
        Optional<TileTorqueSidedCell> te = WorldTools.getTile(world, pos, TileTorqueSidedCell.class);
        if (te.isPresent()) {
            TileTorqueSidedCell tile = te.get();
            boolean[] sides = tile.getConnections();
            if (sides[0]) {
                y1 = 0.0f;
            }
            if (sides[1]) {
                y2 = 1.0f;
            }
            if (sides[2]) {
                z1 = 0.0f;
            }
            if (sides[3]) {
                z2 = 1.0f;
            }
            if (sides[4]) {
                x1 = 0.0f;
            }
            if (sides[5]) {
                x2 = 1.0f;
            }
        }
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

