/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockTorqueBase;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.FlywheelControllerRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelControllerHeavy;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelControllerLight;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelControllerMedium;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;

public class BlockFlywheelController
extends BlockTorqueBase
implements IBakeryProvider {
    public static final IUnlistedProperty<Float> FLYWHEEL_ROTATION = new PropertyFloat("flywheel_rotation");

    public BlockFlywheelController(String regName) {
        super(Material.field_151576_e, regName);
    }

    @Override
    protected void addProperties(BlockStateContainer.Builder builder) {
        builder.add(new IProperty[]{AutomationProperties.TIER}).add(new IUnlistedProperty[]{FLYWHEEL_ROTATION, AutomationProperties.USE_INPUT, AutomationProperties.INPUT_ROTATION});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AutomationProperties.TIER, (Comparable)((Object)TorqueTier.byMetadata(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))).getMeta();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return FlywheelControllerRenderer.INSTANCE.handleState((IExtendedBlockState)state, world, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(placer.func_184586_b(hand).func_77960_j());
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))) {
            case LIGHT: {
                return new TileFlywheelControllerLight();
            }
            case MEDIUM: {
                return new TileFlywheelControllerMedium();
            }
            case HEAVY: {
                return new TileFlywheelControllerHeavy();
            }
        }
        return null;
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }

    @Override
    public boolean invertFacing() {
        return false;
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoaderHelper.registerItem(this, "automation", "light", false);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(new IProperty[]{AutomationProperties.TIER}).addKeyProperties(CoreProperties.UNLISTED_FACING, AutomationProperties.DYNAMIC, FLYWHEEL_ROTATION, AutomationProperties.USE_INPUT).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.ROTATIONS).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.INPUT_ROTATION).build());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                switch ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))) {
                    case LIGHT: {
                        return FlywheelControllerRenderer.LIGHT_MODEL_LOCATION;
                    }
                    case MEDIUM: {
                        return FlywheelControllerRenderer.MEDIUM_MODEL_LOCATION;
                    }
                }
                return FlywheelControllerRenderer.HEAVY_MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelControllerRenderer.LIGHT_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelControllerRenderer.INSTANCE.getSprite(TorqueTier.LIGHT);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelControllerRenderer.MEDIUM_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelControllerRenderer.INSTANCE.getSprite(TorqueTier.MEDIUM);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelControllerRenderer.HEAVY_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelControllerRenderer.INSTANCE.getSprite(TorqueTier.HEAVY);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return FlywheelControllerRenderer.INSTANCE;
    }
}

