/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.SetMultiMap;
import mezz.jei.collect.Table;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipe;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.recipes.InternalRecipeRegistryPlugin;
import mezz.jei.recipes.RecipeCategoryComparator;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.recipes.RecipeRegistryPluginSafeWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry
implements IRecipeRegistry {
    private final IngredientRegistry ingredientRegistry;
    @Deprecated
    private final ImmutableList<IRecipeHandler> unsortedRecipeHandlers;
    private final ImmutableMultimap<String, IRecipeHandler> recipeHandlers;
    private final ImmutableList<IRecipeCategory> recipeCategories;
    private final Set<String> hiddenRecipeCategoryUids = new HashSet<String>();
    private final List<IRecipeCategory> recipeCategoriesVisibleCache = new ArrayList<IRecipeCategory>();
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMultimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap;
    private final ImmutableListMultimap<IRecipeCategory, Object> recipeCatalysts;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final Table<String, Object, IRecipeWrapper> wrapperMaps = new Table(new HashMap(), IdentityHashMap::new);
    private final ListMultiMap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories = new ListMultiMap();
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final List<RecipeRegistryPluginSafeWrapper> plugins = new ArrayList<RecipeRegistryPluginSafeWrapper>();
    private final SetMultiMap<String, IRecipeWrapper> hiddenRecipes = new SetMultiMap(() -> Collections.newSetFromMap(new IdentityHashMap()));

    public RecipeRegistry(List<IRecipeCategory> recipeCategories, List<IRecipeHandler> unsortedRecipeHandlers, ListMultiMap<String, IRecipeHandler> recipeHandlers, ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers, List<Object> unsortedRecipes, ListMultiMap<String, Object> recipes, ListMultiMap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap, ListMultiMap<String, Object> recipeCatalysts, IngredientRegistry ingredientRegistry, List<IRecipeRegistryPlugin> plugins) {
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = recipeTransferHandlers;
        this.recipeHandlers = recipeHandlers.toImmutable();
        this.unsortedRecipeHandlers = RecipeRegistry.buildRecipeHandlersList(unsortedRecipeHandlers);
        this.recipeClickableAreasMap = recipeClickableAreasMap.toImmutable();
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.addRecipes(unsortedRecipes, recipes);
        ImmutableListMultimap.Builder recipeCatalystsBuilder = ImmutableListMultimap.builder();
        ImmutableMultimap.Builder categoriesForRecipeCatalystKeysBuilder = ImmutableMultimap.builder();
        for (Map.Entry recipeCatalystEntry : recipeCatalysts.entrySet()) {
            String recipeCategoryUid = (String)recipeCatalystEntry.getKey();
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null) continue;
            Collection catalystIngredients = (Collection)recipeCatalystEntry.getValue();
            recipeCatalystsBuilder.putAll((Object)recipeCategory, (Iterable)catalystIngredients);
            for (Object catalystIngredient : catalystIngredients) {
                IIngredientType ingredientType = ingredientRegistry.getIngredientType(catalystIngredient);
                IIngredientHelper ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
                this.recipeInputMap.addRecipeCategory(recipeCategory, catalystIngredient, ingredientHelper);
                String catalystIngredientKey = this.getUniqueId(catalystIngredient);
                categoriesForRecipeCatalystKeysBuilder.put((Object)catalystIngredientKey, (Object)recipeCategoryUid);
            }
        }
        this.recipeCatalysts = recipeCatalystsBuilder.build();
        ImmutableMultimap categoriesForRecipeCatalystKeys = categoriesForRecipeCatalystKeysBuilder.build();
        InternalRecipeRegistryPlugin internalRecipeRegistryPlugin = new InternalRecipeRegistryPlugin(this, (ImmutableMultimap<String, String>)categoriesForRecipeCatalystKeys, ingredientRegistry, this.recipeCategoriesMap, this.recipeInputMap, this.recipeOutputMap, this.recipeWrappersForCategories);
        this.plugins.add(new RecipeRegistryPluginSafeWrapper(internalRecipeRegistryPlugin));
        for (IRecipeRegistryPlugin plugin : plugins) {
            this.plugins.add(new RecipeRegistryPluginSafeWrapper(plugin));
        }
        this.recipeCategories = ImmutableList.copyOf(recipeCategories);
    }

    private <T> String getUniqueId(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient);
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(List<IRecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableList<IRecipeHandler> buildRecipeHandlersList(List<IRecipeHandler> recipeHandlers) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (recipeHandler == null) continue;
            Class recipeClass = recipeHandler.getRecipeClass();
            if (recipeHandlerClasses.contains(recipeClass)) {
                Log.get().error("A Recipe Handler has already been registered for this recipe class: {}", (Object)recipeClass.getName());
                continue;
            }
            recipeHandlerClasses.add(recipeClass);
            listBuilder.add((Object)recipeHandler);
        }
        return listBuilder.build();
    }

    private void addRecipes(List<Object> unsortedRecipes, ListMultiMap<String, Object> recipes) {
        Set entries = recipes.entrySet();
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Loading recipes", (int)(recipes.getTotalSize() + unsortedRecipes.size()));
        for (Map.Entry entry : entries) {
            String recipeCategoryUid = (String)entry.getKey();
            for (Object recipe : (List)entry.getValue()) {
                progressBar.step("");
                this.addRecipe(recipe, recipe.getClass(), recipeCategoryUid);
            }
        }
        for (Object object : unsortedRecipes) {
            progressBar.step("");
            this.addRecipe(object, object.getClass(), null);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return new Focus<V>(mode, ingredient);
    }

    @Override
    @Deprecated
    public void addRecipe(Object recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.assertMainThread();
        this.addRecipe(recipe, recipe.getClass(), null);
    }

    @Override
    @Deprecated
    public void addRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
        if (recipeCategory == null) {
            Log.get().error("No recipe category registered for recipeCategoryUid: {}", (Object)recipeCategoryUid);
            return;
        }
        if (this.hiddenRecipes.contains(recipeCategoryUid, recipe)) {
            this.unhideRecipe(recipe, recipeCategoryUid);
        } else {
            this.addRecipe(recipe, recipe, recipeCategory);
        }
    }

    private <T> void addRecipe(T recipe, Class<? extends T> recipeClass, @Nullable String recipeCategoryUid) {
        IRecipeWrapper recipeWrapper;
        if (recipeCategoryUid == null) {
            IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass, null);
            if (recipeHandler != null) {
                recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
            } else {
                Log.get().error("Could not determine recipe category for recipe: {}", recipeClass);
                return;
            }
        }
        if ((recipeWrapper = this.getRecipeWrapper(recipe, recipeClass, recipeCategoryUid)) != null) {
            IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
            if (recipeCategory == null) {
                Log.get().error("No recipe category registered for recipeCategoryUid: {}", (Object)recipeCategoryUid);
                return;
            }
            this.addRecipe(recipe, recipeWrapper, recipeCategory);
        } else {
            Log.get().debug("No recipe wrapper for recipe: {}", (Object)ErrorUtil.getNameForRecipe(recipe));
        }
    }

    @Override
    @Nullable
    public IRecipeCategory getRecipeCategory(String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        return (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
    }

    private static <T> void logBrokenRecipeHandler(T recipe, IRecipeHandler<T> recipeHandler, Throwable e) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e2) {
            Log.get().error("Failed recipe.toString", (Throwable)e2);
            recipeInfoBuilder.append(recipe.getClass());
        }
        recipeInfoBuilder.append("\nRecipe Handler failed to create recipe wrapper\n");
        recipeInfoBuilder.append(recipeHandler.getClass());
        Log.get().error("{}", (Object)recipeInfoBuilder.toString(), (Object)e);
    }

    private <T> void addRecipe(T recipe, IRecipeWrapper recipeWrapper, IRecipeCategory recipeCategory) {
        try {
            this.addRecipeUnchecked(recipe, recipeWrapper, recipeCategory);
        }
        catch (BrokenCraftingRecipeException e) {
            Log.get().error("Found a broken crafting recipe.", (Throwable)e);
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeWrapper);
            Log.get().error("Found a broken recipe: {}\n", (Object)recipeInfo, (Object)e);
        }
    }

    private <T> void addRecipeUnchecked(T recipe, IRecipeWrapper recipeWrapper, IRecipeCategory recipeCategory) {
        this.wrapperMaps.put(recipeCategory.getUid(), recipe, recipeWrapper);
        Ingredients ingredients = this.getIngredients(recipeWrapper);
        this.recipeInputMap.addRecipe(recipeWrapper, recipeCategory, ingredients.getInputIngredients());
        this.recipeOutputMap.addRecipe(recipeWrapper, recipeCategory, ingredients.getOutputIngredients());
        this.recipeWrappersForCategories.put(recipeCategory, recipeWrapper);
        this.unhideRecipe(recipeWrapper, recipeCategory.getUid());
        this.recipeCategoriesVisibleCache.clear();
    }

    public Ingredients getIngredients(IRecipeWrapper recipeWrapper) {
        Ingredients ingredients = new Ingredients();
        recipeWrapper.getIngredients(ingredients);
        return ingredients;
    }

    @Override
    @Deprecated
    public void removeRecipe(Object recipe) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.assertMainThread();
        List<IRecipeHandler<?>> recipeHandlers1 = this.getRecipeHandlers(recipe.getClass());
        for (IRecipeHandler<?> recipeHandler : recipeHandlers1) {
            String recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
            this.removeRecipe(recipe, recipeCategoryUid);
        }
    }

    private <T> void removeRecipe(T recipe, String recipeCategoryUid) {
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.get().error("No recipe category registered for recipeCategoryUid: {}", (Object)recipeCategoryUid);
            return;
        }
        try {
            IRecipeWrapper recipeWrapper = this.getRecipeWrapper(recipe, recipeCategory.getUid());
            if (recipeWrapper != null) {
                this.hideRecipe(recipeWrapper, recipeCategoryUid);
            }
        }
        catch (BrokenCraftingRecipeException e) {
            Log.get().error("Found a broken crafting recipe.", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public void removeRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.hideRecipe(recipe, recipeCategoryUid);
    }

    @Override
    @Deprecated
    public void addSmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        ErrorUtil.checkNotEmpty(inputs, "inputs");
        ErrorUtil.checkNotEmpty(output, "output");
        SmeltingRecipe smeltingRecipe = new SmeltingRecipe(inputs, output);
        this.addRecipe(smeltingRecipe);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createSmeltingRecipe(List<ItemStack> inputs, ItemStack output) {
        return Internal.getHelpers().getVanillaRecipeFactory().createSmeltingRecipe(inputs, output);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        return Internal.getHelpers().getVanillaRecipeFactory().createAnvilRecipe(leftInput, rightInputs, outputs);
    }

    @Override
    @Deprecated
    public IRecipeWrapper createBrewingRecipe(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput) {
        return Internal.getHelpers().getVanillaRecipeFactory().createBrewingRecipe(ingredients, potionInput, potionOutput);
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories() {
        if (this.recipeCategoriesVisibleCache.isEmpty()) {
            for (IRecipeCategory recipeCategory : this.recipeCategories) {
                if (!this.isCategoryVisible(recipeCategory)) continue;
                this.recipeCategoriesVisibleCache.add(recipeCategory);
            }
        }
        return this.recipeCategoriesVisibleCache;
    }

    private boolean isCategoryVisible(IRecipeCategory<?> recipeCategory) {
        List<Object> visibleCatalysts;
        if (this.hiddenRecipeCategoryUids.contains(recipeCategory.getUid())) {
            return false;
        }
        List<Object> allCatalysts = this.getRecipeCatalysts(recipeCategory, true);
        if (!allCatalysts.isEmpty() && (visibleCatalysts = this.getRecipeCatalysts(recipeCategory, false)).isEmpty()) {
            return false;
        }
        return !this.getRecipeWrappers(recipeCategory).isEmpty();
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories(List<String> recipeCategoryUids) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || !this.getRecipeCategories().contains(recipeCategory)) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Deprecated
    @Nullable
    public <T> IRecipeHandler<T> getRecipeHandler(Class<? extends T> recipeClass) {
        return this.getRecipeHandler(recipeClass, null);
    }

    @Override
    @Nullable
    public IRecipeWrapper getRecipeWrapper(Object recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotEmpty(recipeCategoryUid, "recipeCategoryUid");
        return this.getRecipeWrapper(recipe, recipe.getClass(), recipeCategoryUid);
    }

    @Nullable
    private <T> IRecipeWrapper getRecipeWrapper(T recipe, Class<? extends T> recipeClass, String recipeCategoryUid) {
        IRecipeWrapper recipeWrapper = this.wrapperMaps.get(recipeCategoryUid, recipe);
        if (recipeWrapper != null) {
            return recipeWrapper;
        }
        IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass, recipeCategoryUid);
        if (recipeHandler != null) {
            try {
                if (!recipeHandler.isRecipeValid(recipe)) {
                    return null;
                }
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Recipe check crashed", e);
                return null;
            }
            try {
                recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
                this.wrapperMaps.put(recipeCategoryUid, recipe, recipeWrapper);
                return recipeWrapper;
            }
            catch (LinkageError | RuntimeException e) {
                RecipeRegistry.logBrokenRecipeHandler(recipe, recipeHandler, e);
                return null;
            }
        }
        if (recipe instanceof IRecipeWrapper) {
            return (IRecipeWrapper)recipe;
        }
        return null;
    }

    @Nullable
    private <T> IRecipeHandler<T> getRecipeHandler(Class<? extends T> recipeClass, @Nullable String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ImmutableCollection recipeHandlers = recipeCategoryUid != null ? this.recipeHandlers.get((Object)recipeCategoryUid) : this.recipeHandlers.values();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        return null;
    }

    @Deprecated
    private <T> List<IRecipeHandler<T>> getRecipeHandlers(Class<? extends T> recipeClass) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        ArrayList<IRecipeHandler<T>> recipeHandlers = new ArrayList<IRecipeHandler<T>>();
        ImmutableCollection allRecipeHandlers = this.recipeHandlers.values();
        for (IRecipeHandler recipeHandler : allRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : allRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        for (IRecipeHandler recipeHandler : this.unsortedRecipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            recipeHandlers.add(recipeHandler);
        }
        return recipeHandlers;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        ImmutableCollection recipeClickableAreas = this.recipeClickableAreasMap.get(gui.getClass());
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    @Nullable
    private static FluidStack getFluidFromItemBlock(IFocus<?> focus) {
        Block block;
        Fluid fluid;
        ItemStack itemStack;
        Item item;
        Object ingredient = focus.getValue();
        if (ingredient instanceof ItemStack && (item = (itemStack = (ItemStack)ingredient).func_77973_b()) instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    @Override
    public <V> List<IRecipeCategory> getRecipeCategories(IFocus<V> focus) {
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus = Focus.check(focus));
        if (fluidStack != null) {
            return this.getRecipeCategories(this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<String> allRecipeCategoryUids = new ArrayList<String>();
        for (IRecipeRegistryPlugin iRecipeRegistryPlugin : this.plugins) {
            List<String> recipeCategoryUids = iRecipeRegistryPlugin.getRecipeCategoryUids(focus);
            for (String recipeCategoryUid : recipeCategoryUids) {
                if (allRecipeCategoryUids.contains(recipeCategoryUid)) continue;
                if (this.hiddenRecipes.containsKey(recipeCategoryUid)) {
                    List recipeWrappers;
                    IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
                    if (recipeCategory == null || (recipeWrappers = this.getRecipeWrappers(recipeCategory, focus)).isEmpty()) continue;
                    allRecipeCategoryUids.add(recipeCategoryUid);
                    continue;
                }
                allRecipeCategoryUids.add(recipeCategoryUid);
            }
        }
        return this.getRecipeCategories(allRecipeCategoryUids);
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        focus = Focus.check(focus);
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeWrappers(recipeCategory, this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin iRecipeRegistryPlugin : this.plugins) {
            List<T> recipeWrappers = iRecipeRegistryPlugin.getRecipeWrappers(recipeCategory, focus);
            allRecipeWrappers.addAll(recipeWrappers);
        }
        Set hidden = (Set)this.hiddenRecipes.get(recipeCategory.getUid());
        allRecipeWrappers.removeAll(hidden);
        return allRecipeWrappers;
    }

    @Override
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin iRecipeRegistryPlugin : this.plugins) {
            List<T> recipeWrappers = iRecipeRegistryPlugin.getRecipeWrappers(recipeCategory);
            allRecipeWrappers.addAll(recipeWrappers);
        }
        Set hidden = (Set)this.hiddenRecipes.get(recipeCategory.getUid());
        allRecipeWrappers.removeAll(hidden);
        return allRecipeWrappers;
    }

    @Override
    @Deprecated
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory, @Nullable IFocus focus) {
        Object ingredient;
        if (focus != null) {
            focus = Focus.check(focus);
        }
        List<ItemStack> craftingItems = this.getCraftingItems(recipeCategory);
        if (focus != null && focus.getMode() == IFocus.Mode.INPUT && (ingredient = focus.getValue()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            IIngredientHelper<ItemStack> ingredientHelper = this.ingredientRegistry.getIngredientHelper(VanillaTypes.ITEM);
            ItemStack matchingStack = ingredientHelper.getMatch(craftingItems, itemStack);
            if (matchingStack != null) {
                return Collections.singletonList(matchingStack);
            }
        }
        return craftingItems;
    }

    @Override
    @Deprecated
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        List<Object> objects = this.getRecipeCatalysts(recipeCategory);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Object object : objects) {
            if (!(object instanceof ItemStack)) continue;
            itemStacks.add((ItemStack)object);
        }
        return Collections.unmodifiableList(itemStacks);
    }

    public List<Object> getRecipeCatalysts(IRecipeCategory recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ImmutableList catalysts = this.recipeCatalysts.get((Object)recipeCategory);
        if (includeHidden) {
            return catalysts;
        }
        ArrayList<Object> visibleCatalysts = new ArrayList<Object>();
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        for (Object catalyst : catalysts) {
            if (!this.ingredientRegistry.isIngredientVisible(catalyst, ingredientFilter)) continue;
            visibleCatalysts.add(catalyst);
        }
        return visibleCatalysts;
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory recipeCategory) {
        return this.getRecipeCatalysts(recipeCategory, false);
    }

    @Override
    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(Container container, IRecipeCategory recipeCategory) {
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler recipeTransferHandler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)recipeCategory.getUid());
        if (recipeTransferHandler != null) {
            return recipeTransferHandler;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)"universal recipe transfer handler");
    }

    @Override
    public <T extends IRecipeWrapper> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipeWrapper, IFocus<?> focus) {
        focus = Focus.check(focus);
        RecipeLayout recipeLayout = RecipeLayout.create(-1, recipeCategory, recipeWrapper, focus, 0, 0);
        Preconditions.checkNotNull((Object)recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout;
    }

    @Override
    public void hideRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.hiddenRecipes.put(recipeCategoryUid, recipe);
        this.recipeCategoriesVisibleCache.clear();
    }

    @Override
    public void unhideRecipe(IRecipeWrapper recipe, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.hiddenRecipes.remove(recipeCategoryUid, recipe);
        this.recipeCategoriesVisibleCache.clear();
    }

    @Override
    public void hideRecipeCategory(String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            throw new IllegalArgumentException("Unknown recipe category: " + recipeCategoryUid);
        }
        this.hiddenRecipeCategoryUids.add(recipeCategoryUid);
        this.recipeCategoriesVisibleCache.remove(recipeCategory);
    }

    @Override
    public void unhideRecipeCategory(String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        if (!this.recipeCategoriesMap.containsKey((Object)recipeCategoryUid)) {
            throw new IllegalArgumentException("Unknown recipe category: " + recipeCategoryUid);
        }
        this.hiddenRecipeCategoryUids.remove(recipeCategoryUid);
        this.recipeCategoriesVisibleCache.clear();
    }

    @Override
    @Deprecated
    public void hideRecipe(IRecipeWrapper recipe) {
        this.hideRecipe(recipe, "minecraft.crafting");
    }

    @Override
    @Deprecated
    public void unhideRecipe(IRecipeWrapper recipe) {
        this.unhideRecipe(recipe, "minecraft.crafting");
    }
}

