/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeCategoryTab;
import mezz.jei.gui.recipes.RecipeGuiTab;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class RecipeGuiTabs
implements IMouseHandler,
IPaged {
    private final IRecipeGuiLogic recipeGuiLogic;
    private final List<RecipeGuiTab> tabs = new ArrayList<RecipeGuiTab>();
    private final PageNavigation pageNavigation;
    private final Rectangle area = new Rectangle();
    private int pageCount = 1;
    private int pageNumber = 0;
    private int categoriesPerPage = 1;

    public RecipeGuiTabs(IRecipeGuiLogic recipeGuiLogic) {
        this.recipeGuiLogic = recipeGuiLogic;
        this.pageNavigation = new PageNavigation(this, true);
    }

    public void initLayout(GuiProperties guiProperties) {
        ImmutableList<IRecipeCategory> categories = this.recipeGuiLogic.getRecipeCategories();
        if (!categories.isEmpty()) {
            int totalWidth = 0;
            this.categoriesPerPage = 0;
            for (int i = 0; i < categories.size() && totalWidth + 24 <= guiProperties.getGuiXSize() - 4; ++i) {
                totalWidth += 24;
                ++this.categoriesPerPage;
            }
            this.area.width = totalWidth;
            this.area.height = 24;
            this.area.x = guiProperties.getGuiLeft() + 2;
            this.area.y = guiProperties.getGuiTop() - 24 + 3;
            this.pageCount = MathUtil.divideCeil(categories.size(), this.categoriesPerPage);
            IRecipeCategory currentCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
            int categoryIndex = categories.indexOf((Object)currentCategory);
            this.pageNumber = categoryIndex / this.categoriesPerPage;
            Rectangle navigationArea = new Rectangle(this.area);
            navigationArea.height = 20;
            navigationArea.translate(0, -(2 + navigationArea.height));
            this.pageNavigation.updateBounds(navigationArea);
            this.updateLayout();
        }
    }

    private void updateLayout() {
        int index;
        this.tabs.clear();
        ImmutableList<IRecipeCategory> categories = this.recipeGuiLogic.getRecipeCategories();
        int tabX = this.area.x;
        int startIndex = this.pageNumber * this.categoriesPerPage;
        for (int i = 0; i < this.categoriesPerPage && (index = i + startIndex) < categories.size(); ++i) {
            IRecipeCategory category = (IRecipeCategory)categories.get(index);
            RecipeCategoryTab tab = new RecipeCategoryTab(this.recipeGuiLogic, category, tabX, this.area.y);
            this.tabs.add(tab);
            tabX += 24;
        }
        this.pageNavigation.updatePageState();
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        IRecipeCategory selectedCategory = this.recipeGuiLogic.getSelectedRecipeCategory();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RecipeGuiTab hovered = null;
        GlStateManager.func_179097_i();
        GlStateManager.func_179141_d();
        for (RecipeGuiTab tab : this.tabs) {
            boolean selected = tab.isSelected(selectedCategory);
            tab.draw(minecraft, selected, mouseX, mouseY);
            if (!tab.isMouseOver(mouseX, mouseY)) continue;
            hovered = tab;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179126_j();
        this.pageNavigation.draw(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
        if (hovered != null) {
            List<String> tooltip = hovered.getTooltip();
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY) || this.pageNavigation.isMouseOver();
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (RecipeGuiTab tab : this.tabs) {
                if (!tab.isMouseOver(mouseX, mouseY)) continue;
                tab.handleMouseClicked(mouseX, mouseY, mouseButton);
                return true;
            }
            if (this.pageNavigation.isMouseOver()) {
                return this.pageNavigation.handleMouseClickedButtons(mouseX, mouseY);
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        return false;
    }

    @Override
    public boolean nextPage() {
        this.pageNumber = this.hasNext() ? ++this.pageNumber : 0;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.pageNumber + 1 < this.pageCount;
    }

    @Override
    public boolean previousPage() {
        this.pageNumber = this.hasPrevious() ? --this.pageNumber : this.pageCount - 1;
        this.updateLayout();
        return true;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }
}

