/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.timer;

import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.bookshelf.data.Blockstates;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityTimer
extends TileEntityBasicTickable {
    private static final int MAXDELAY = 12000;
    private static final int MINDELAY = 10;
    private int currentTime = 0;
    private int delayTime = 100;
    private boolean disabled = false;

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74768_a("CurrentTime", this.currentTime);
        dataTag.func_74768_a("TickRate", this.delayTime);
        dataTag.func_74757_a("Disabled", this.disabled);
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.currentTime = dataTag.func_74762_e("CurrentTime");
        this.delayTime = dataTag.func_74762_e("TickRate");
        this.disabled = dataTag.func_74767_n("Disabled");
    }

    public void onEntityUpdate() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c) || this.disabled) {
            return;
        }
        if (this.currentTime >= this.delayTime) {
            this.field_145850_b.func_180501_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)Blockstates.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.field_145850_b.func_175684_a(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b));
            this.currentTime = 0;
        } else {
            ++this.currentTime;
        }
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(int currentTime) {
        this.currentTime = currentTime;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public void setDelayTime(int tickRate) {
        this.delayTime = tickRate < 10 ? 10 : (tickRate > 12000 ? 12000 : tickRate);
    }

    public void addTime(int time) {
        int newTime = this.delayTime + time;
        this.setDelayTime(newTime < 12000 ? newTime : 12000);
    }

    public void removeTime(int time) {
        int newTime = this.delayTime - time;
        this.setDelayTime(newTime > 10 ? newTime : 10);
    }
}

