/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class FileUtils {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final double KB_D = 1024.0;
    public static final double MB_D = 1048576.0;
    public static final double GB_D = 1.073741824E9;
    public static final Comparator<File> FILE_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    public static final Comparator<File> DEEP_FILE_COMPARATOR = (o1, o2) -> o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath());

    public static File newFile(File file) {
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void save(File file, List<String> list) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
        BufferedWriter br = new BufferedWriter(fw);
        for (String s : list) {
            br.write(s);
            br.write(10);
        }
        br.close();
        fw.close();
    }

    public static void save(File file, String string) throws Exception {
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
        BufferedWriter br = new BufferedWriter(fw);
        br.write(string);
        br.close();
        fw.close();
    }

    public static void saveSafe(File file, List<String> list) {
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try {
                FileUtils.save(file, list);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public static void saveSafe(File file, String string) {
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try {
                FileUtils.save(file, string);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }

    public static void downloadFile(URL url, File out, Proxy proxy) throws Exception {
        try (InputStream input = url.openConnection(proxy).getInputStream();
             ReadableByteChannel channel = Channels.newChannel(input);
             FileOutputStream output = new FileOutputStream(out);){
            output.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
        }
    }

    public static List<File> listTree(File file) {
        ArrayList<File> l = new ArrayList<File>();
        FileUtils.listTree0(l, file);
        return l;
    }

    public static void listTree0(List<File> list, File file) {
        if (file.isDirectory()) {
            File[] fl = file.listFiles();
            if (fl != null && fl.length > 0) {
                for (File aFl : fl) {
                    FileUtils.listTree0(list, aFl);
                }
            }
        } else if (file.isFile()) {
            list.add(file);
        }
    }

    public static long getSize(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long length = 0L;
            File[] f1 = file.listFiles();
            if (f1 != null && f1.length > 0) {
                for (File aF1 : f1) {
                    length += FileUtils.getSize(aF1);
                }
            }
            return length;
        }
        return 0L;
    }

    public static String getSizeString(double b) {
        if (b >= 1.073741824E9) {
            return String.format("%.1fGB", b / 1.073741824E9);
        }
        if (b >= 1048576.0) {
            return String.format("%.1fMB", b / 1048576.0);
        }
        if (b >= 1024.0) {
            return String.format("%.1fKB", b / 1024.0);
        }
        return (long)b + "B";
    }

    public static String getSizeString(File file) {
        return FileUtils.getSizeString(FileUtils.getSize(file));
    }

    public static void copyFile(File src, File dst) throws Exception {
        if (src.exists() && !src.equals(dst)) {
            if (src.isDirectory() && dst.isDirectory()) {
                for (File f : FileUtils.listTree(src)) {
                    File dst1 = new File(dst.getAbsolutePath() + File.separatorChar + f.getAbsolutePath().replace(src.getAbsolutePath(), ""));
                    FileUtils.copyFile(f, dst1);
                }
            } else {
                dst = FileUtils.newFile(dst);
                try (FileInputStream fis = new FileInputStream(src);
                     FileOutputStream fos = new FileOutputStream(dst);
                     FileChannel srcC = fis.getChannel();
                     FileChannel dstC = fos.getChannel();){
                    dstC.transferFrom(srcC, 0L, srcC.size());
                }
            }
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        String[] files = file.list();
        if (files != null) {
            for (String s : files) {
                FileUtils.delete(new File(file, s));
            }
        }
        return file.delete();
    }

    public static String getBaseName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }

    public static String getExtension(File file) {
        if (file.isDirectory()) {
            return "";
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(index + 1);
    }
}

