/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.math;

import com.feed_the_beast.ftblib.lib.util.StringUtils;

public class Ticks {
    public static final Ticks NO_TICKS = new Ticks(0L);
    public static final Ticks ONE_TICK = new Ticks(1L);
    public static final Ticks SECOND = ONE_TICK.x(20L);
    public static final long TICK_MS = 1000L / SECOND.ticks();
    public static final Ticks MINUTE = SECOND.x(60L);
    public static final Ticks HOUR = MINUTE.x(60L);
    public static final Ticks DAY = HOUR.x(24L);
    public static final Ticks WEEK = DAY.x(7L);
    private final long ticks;

    public static Ticks get(long ticks) {
        if (ticks == 0L) {
            return NO_TICKS;
        }
        if (ticks == 1L) {
            return ONE_TICK;
        }
        return new Ticks(Math.max(0L, ticks));
    }

    public static Ticks getFromMillis(long millis) {
        return Ticks.get(millis / TICK_MS);
    }

    public static Ticks get(String value) throws NumberFormatException {
        if (value.isEmpty() || value.equals("0s")) {
            return NO_TICKS;
        }
        if (value.length() == 2 && value.charAt(0) == '1') {
            switch (value.charAt(1)) {
                case 'T': 
                case 't': {
                    return ONE_TICK;
                }
                case 'S': 
                case 's': {
                    return SECOND;
                }
                case 'M': 
                case 'm': {
                    return MINUTE;
                }
                case 'H': 
                case 'h': {
                    return HOUR;
                }
                case 'D': 
                case 'd': {
                    return DAY;
                }
                case 'W': 
                case 'w': {
                    return WEEK;
                }
            }
        }
        Ticks ticks = NO_TICKS;
        for (String s : value.split(" ")) {
            if (s.isEmpty()) continue;
            try {
                switch (s.charAt(s.length() - 1)) {
                    case 'T': 
                    case 't': {
                        ticks = ticks.add(Long.parseLong(s.substring(0, s.length() - 1)));
                        break;
                    }
                    case 'S': 
                    case 's': {
                        ticks = ticks.add(SECOND.x(Long.parseLong(s.substring(0, s.length() - 1))));
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        ticks = ticks.add(MINUTE.x(Long.parseLong(s.substring(0, s.length() - 1))));
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        ticks = ticks.add(HOUR.x(Long.parseLong(s.substring(0, s.length() - 1))));
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        ticks = ticks.add(DAY.x(Long.parseLong(s.substring(0, s.length() - 1))));
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        ticks = ticks.add(WEEK.x(Long.parseLong(s.substring(0, s.length() - 1))));
                        break;
                    }
                    default: {
                        ticks = ticks.add(Long.parseLong(s));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ticks;
    }

    private Ticks(long t) {
        this.ticks = t;
    }

    public long ticks() {
        return this.ticks;
    }

    public boolean hasTicks() {
        return this.ticks > 0L;
    }

    public Ticks x(long x) {
        return x == 1L ? this : Ticks.get(this.ticks * x);
    }

    public Ticks x(double x) {
        return x == 1.0 ? this : Ticks.get((long)((double)this.ticks * x));
    }

    public Ticks add(long t) {
        return t == 0L ? this : Ticks.get(this.ticks + t);
    }

    public Ticks add(Ticks t) {
        return this.add(t.ticks);
    }

    public long millis() {
        return this.ticks * TICK_MS;
    }

    public long seconds() {
        return this.ticks / Ticks.SECOND.ticks;
    }

    public double secondsd() {
        return (double)this.ticks / (double)Ticks.SECOND.ticks;
    }

    public long minutes() {
        return this.ticks / Ticks.MINUTE.ticks;
    }

    public double minutesd() {
        return (double)this.ticks / (double)Ticks.MINUTE.ticks;
    }

    public long hours() {
        return this.ticks / Ticks.HOUR.ticks;
    }

    public double hoursd() {
        return (double)this.ticks / (double)Ticks.HOUR.ticks;
    }

    public long days() {
        return this.ticks / Ticks.DAY.ticks;
    }

    public double daysd() {
        return (double)this.ticks / (double)Ticks.DAY.ticks;
    }

    public long weeks() {
        return this.ticks / Ticks.WEEK.ticks;
    }

    public double weeksd() {
        return (double)this.ticks / (double)Ticks.WEEK.ticks;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Ticks && this.equalsTimer((Ticks)o);
    }

    public boolean equalsTimer(Ticks t) {
        return this.ticks == t.ticks;
    }

    public int hashCode() {
        return Long.hashCode(this.ticks);
    }

    public String toString() {
        long t;
        boolean hasSeconds;
        boolean hasMinutes;
        boolean hasHours;
        boolean hasDays;
        boolean hasWeeks;
        if (this.ticks <= 0L) {
            return "0s";
        }
        StringBuilder builder = new StringBuilder();
        if (this.ticks < 20L) {
            builder.append(this.ticks);
            builder.append('t');
            return builder.toString();
        }
        long weeks = this.weeks();
        boolean bl = hasWeeks = weeks > 0L;
        if (hasWeeks) {
            builder.append(weeks);
            builder.append('w');
        }
        long days = this.days() % 7L;
        boolean bl2 = hasDays = hasWeeks || days != 0L;
        if (days != 0L) {
            if (hasWeeks) {
                builder.append(' ');
            }
            builder.append(days);
            builder.append('d');
        }
        long hours = this.hours() % 24L;
        boolean bl3 = hasHours = hasDays || hours != 0L;
        if (hours != 0L) {
            if (hasDays) {
                builder.append(' ');
            }
            builder.append(hours);
            builder.append('h');
        }
        long minutes = this.minutes() % 60L;
        boolean bl4 = hasMinutes = hasHours || minutes != 0L;
        if (minutes != 0L) {
            if (hasHours) {
                builder.append(' ');
            }
            builder.append(minutes);
            builder.append('m');
        }
        long seconds = this.seconds() % 60L;
        boolean bl5 = hasSeconds = hasMinutes || seconds != 0L;
        if (seconds != 0L) {
            if (hasMinutes) {
                builder.append(' ');
            }
            builder.append(seconds);
            builder.append('s');
        }
        if ((t = this.ticks % 20L) != 0L) {
            if (hasSeconds) {
                builder.append(' ');
            }
            builder.append(t);
            builder.append('t');
        }
        return builder.toString();
    }

    public String toTimeString() {
        return StringUtils.getTimeString(this.millis());
    }
}

