/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item;

import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public class ItemEntryWithCount {
    public static final ItemEntryWithCount EMPTY = new ItemEntryWithCount(ItemEntry.EMPTY, 0){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    public final ItemEntry entry;
    public int count;

    public ItemEntryWithCount(ItemEntry e, int c) {
        this.entry = e;
        this.count = c;
    }

    public ItemEntryWithCount(NBTTagCompound nbt) {
        Item item;
        Item item2;
        int[] ai;
        NBTBase id = nbt.func_74781_a("I");
        if (id == null) {
            ItemStack stack = new ItemStack(nbt);
            this.entry = ItemEntry.get(stack);
            this.count = nbt.func_74764_b("RealCount") ? nbt.func_74762_e("RealCount") : stack.func_190916_E();
            return;
        }
        if (id instanceof NBTTagIntArray && (ai = ((NBTTagIntArray)id).func_150302_c()).length > 0 && (item2 = (Item)Item.field_150901_e.func_148754_a(ai[0])) != null && item2 != Items.field_190931_a) {
            this.count = 1;
            int meta = 0;
            if (ai.length >= 2) {
                this.count = ai[1];
            }
            if (ai.length >= 3) {
                meta = ai[2];
            }
            NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("N");
            NBTTagCompound caps = (NBTTagCompound)nbt.func_74781_a("C");
            this.entry = new ItemEntry(item2, meta, tag, caps);
            return;
        }
        Item item3 = item = id instanceof NBTTagString ? (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(((NBTTagString)id).func_150285_a_())) : (Item)Item.field_150901_e.func_148754_a(((NBTPrimitive)id).func_150287_d());
        if (item != null && item != Items.field_190931_a) {
            short meta = nbt.func_74765_d("M");
            NBTTagCompound tag = (NBTTagCompound)nbt.func_74781_a("N");
            NBTTagCompound caps = (NBTTagCompound)nbt.func_74781_a("C");
            this.entry = new ItemEntry(item, meta, tag, caps);
            this.count = nbt.func_74762_e("S");
            this.count = this.count <= 0 ? 1 : this.count;
        } else {
            this.entry = ItemEntry.EMPTY;
            this.count = 0;
        }
    }

    public boolean isEmpty() {
        return this.count <= 0 || this.entry.isEmpty();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.isEmpty()) {
            return nbt;
        }
        if (this.count > 1 || this.entry.metadata > 0) {
            int[] ai = new int[this.entry.metadata > 0 ? 3 : 2];
            ai[0] = Item.field_150901_e.func_148757_b((Object)this.entry.item);
            ai[1] = this.count;
            if (this.entry.metadata > 0) {
                ai[2] = this.entry.metadata;
            }
            nbt.func_74783_a("I", ai);
        } else {
            nbt.func_74768_a("I", Item.field_150901_e.func_148757_b((Object)this.entry.item));
        }
        if (this.entry.nbt != null) {
            nbt.func_74782_a("N", (NBTBase)this.entry.nbt);
        }
        if (this.entry.caps != null) {
            nbt.func_74782_a("C", (NBTBase)this.entry.caps);
        }
        return nbt;
    }

    public ItemStack getStack(boolean copy) {
        return this.entry.getStack(this.count, copy);
    }

    public String toString() {
        return this.serializeNBT().toString();
    }
}

