/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.google.common.base.Objects;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ImageIcon
extends Icon {
    public static final ResourceLocation MISSING_IMAGE = new ResourceLocation("ftblib", "textures/gui/missing_image.png");
    public final ResourceLocation texture;
    public final double minU;
    public final double minV;
    public final double maxU;
    public final double maxV;

    public ImageIcon(ResourceLocation tex, double u0, double v0, double u1, double v1) {
        this.texture = tex;
        this.minU = Math.min(u0, u1);
        this.minV = Math.min(v0, v1);
        this.maxU = Math.max(u0, u1);
        this.maxV = Math.max(v0, v1);
    }

    public ImageIcon(ResourceLocation tex) {
        this(tex, 0.0, 0.0, 1.0, 1.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        TextureManager manager = ClientUtils.MC.func_110434_K();
        ITextureObject tex = manager.func_110581_b(this.texture);
        if (tex == null) {
            tex = new SimpleTexture(this.texture);
            manager.func_110579_a(this.texture, tex);
        }
        GlStateManager.func_179144_i((int)tex.func_110552_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h, Color4I col) {
        this.bindTexture();
        GuiHelper.drawTexturedRect(x, y, w, h, col.whiteIfEmpty(), this.minU, this.minV, this.maxU, this.maxV);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, this.minU, this.minV, this.maxU, this.maxV});
    }

    public String toString() {
        return this.texture.toString();
    }

    public ImageIcon withUV(double u0, double v0, double u1, double v1) {
        return new ImageIcon(this.texture, u0, v0, u1, v1);
    }

    public ImageIcon withUVfromCoords(int x, int y, int w, int h, int tw, int th) {
        return this.withUV((double)x / (double)tw, (double)y / (double)th, (double)(x + w) / (double)tw, (double)(y + h) / (double)th);
    }
}

