/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class ScrollBar
extends Widget {
    public final Plane plane;
    private int sliderSize;
    private int value = 0;
    private int scrollStep = 20;
    private int grab = -10000;
    private int minValue = 0;
    private int maxValue = 100;
    private boolean canAlwaysScroll = false;
    private boolean canAlwaysScrollPlane = true;

    public ScrollBar(Panel parent, Plane p, int ss) {
        super(parent);
        this.plane = p;
        this.sliderSize = Math.max(ss, 0);
    }

    public void setCanAlwaysScroll(boolean v) {
        this.canAlwaysScroll = v;
    }

    public void setCanAlwaysScrollPlane(boolean v) {
        this.canAlwaysScrollPlane = v;
    }

    public void setMinValue(int min) {
        this.minValue = min;
        this.setValue(this.getValue());
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
        this.setValue(this.getValue());
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setScrollStep(int s) {
        this.scrollStep = Math.max(1, s);
    }

    public int getSliderSize() {
        return this.sliderSize;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.grab = this.plane.isVertical ? this.getMouseY() - (this.getY() + this.getValueI(this.height - this.getSliderSize())) : this.getMouseX() - (this.getX() + this.getValueI(this.width - this.getSliderSize()));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int scroll) {
        if (scroll != 0 && this.canMouseScrollPlane() && this.canMouseScroll()) {
            this.setValue(this.getValue() + (scroll < 0 ? this.getScrollStep() : -this.getScrollStep()));
            return true;
        }
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.showValueOnMouseOver()) {
            String t = this.getTitle();
            list.add(t.isEmpty() ? Integer.toString(this.getValue()) : t + ": " + this.getValue());
        }
        if (Theme.renderDebugBoxes) {
            list.add(TextFormatting.DARK_GRAY + "Size: " + this.getSliderSize());
            list.add(TextFormatting.DARK_GRAY + "Max: " + this.getMaxValue());
            list.add(TextFormatting.DARK_GRAY + "Value: " + this.getValue());
        }
    }

    public boolean showValueOnMouseOver() {
        return false;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        int sliderSize = this.getSliderSize();
        if (sliderSize > 0) {
            int v = this.getValue();
            if (this.grab != -10000) {
                if (ScrollBar.isMouseButtonDown(MouseButton.LEFT)) {
                    v = this.plane.isVertical ? (int)((double)((this.getMouseY() - (y + this.grab)) * this.getMaxValue()) / (double)(this.height - sliderSize)) : (int)((double)((this.getMouseX() - (x + this.grab)) * this.getMaxValue()) / (double)(this.width - sliderSize));
                } else {
                    this.grab = -10000;
                }
            }
            this.setValue(v);
        }
        this.drawBackground(theme, x, y, this.width, this.height);
        if (sliderSize > 0) {
            if (this.plane.isVertical) {
                this.drawScrollBar(theme, x, y + this.getValueI(this.height - sliderSize), this.width, sliderSize);
            } else {
                this.drawScrollBar(theme, x + this.getValueI(this.width - sliderSize), y, sliderSize, this.height);
            }
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBarBackground(x, y, w, h, this.getWidgetType());
    }

    public void drawScrollBar(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBar(x, y, w, h, WidgetType.mouseOver(this.grab != -10000), this.plane.isVertical);
    }

    public void onMoved() {
    }

    public boolean canMouseScrollPlane() {
        return this.canAlwaysScrollPlane || ScrollBar.isShiftKeyDown() != this.plane.isVertical;
    }

    public boolean canMouseScroll() {
        return this.canAlwaysScroll || this.isMouseOver();
    }

    public void setValue(int v) {
        if (this.value != (v = MathHelper.func_76125_a((int)v, (int)this.getMinValue(), (int)this.getMaxValue()))) {
            this.value = v;
            this.onMoved();
        }
    }

    public int getValue() {
        return this.value;
    }

    public int getValueI(int max) {
        return (int)MathUtils.map(this.getMinValue(), this.getMaxValue(), 0.0, max, this.value);
    }

    public int getScrollStep() {
        return this.scrollStep;
    }

    public static enum Plane {
        HORIZONTAL(false),
        VERTICAL(true);

        public final boolean isVertical;

        private Plane(boolean v) {
            this.isVertical = v;
        }
    }
}

