/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.client;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.IGuiWrapper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;

public class ClientUtils {
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final NameMap<EnumBlockRenderType> BLOCK_RENDER_TYPE_NAME_MAP = NameMap.create(EnumBlockRenderType.MODEL, EnumBlockRenderType.values());
    public static final NameMap<BlockRenderLayer> BLOCK_RENDER_LAYER_NAME_MAP = NameMap.create(BlockRenderLayer.SOLID, BlockRenderLayer.values());
    public static final Map<ResourceLocation, TextureAtlasSprite> SPRITE_MAP = new HashMap<ResourceLocation, TextureAtlasSprite>();
    public static final ModelRotation[] FACE_ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X90_Y180, ModelRotation.X90_Y0, ModelRotation.X90_Y90, ModelRotation.X90_Y270};
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static EntityItem entityItem;
    public static PlayerHeadIcon localPlayerHead;

    public static int getDim() {
        return ClientUtils.MC.field_71441_e != null ? ClientUtils.MC.field_71441_e.field_73011_w.getDimension() : 0;
    }

    public static void spawnParticle(Particle particle) {
        ClientUtils.MC.field_71452_i.func_78873_a(particle);
    }

    public static void pushBrightness(int u, int t) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)u, (float)t);
    }

    public static void pushMaxBrightness() {
        ClientUtils.pushBrightness(240, 240);
    }

    public static void popBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void execClientCommand(String command, boolean printChat) {
        if (printChat) {
            ClientUtils.MC.field_71456_v.func_146158_b().func_146239_a(command);
        }
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)ClientUtils.MC.field_71439_g, command) == 0) {
            ClientUtils.MC.field_71439_g.func_71165_d(command);
        }
    }

    public static void execClientCommand(String command) {
        ClientUtils.execClientCommand(command, false);
    }

    public static void renderItem(World world, ItemStack stack) {
        if (entityItem == null) {
            entityItem = new EntityItem(world);
        }
        entityItem.func_70029_a(world);
        ClientUtils.entityItem.field_70290_d = 0.0f;
        entityItem.func_92058_a(stack);
        MC.func_175598_ae().func_188391_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB box, Color4I color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int r = color.redi();
        int g = color.greeni();
        int b = color.bluei();
        int a = color.alphai();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static BlockRenderLayer getStrongest(BlockRenderLayer layer1, BlockRenderLayer layer2) {
        return layer1.ordinal() > layer2.ordinal() ? layer1 : layer2;
    }

    public static void runLater(Runnable runnable) {
        new Thread(() -> MC.func_152344_a(runnable)).start();
    }

    public static TextureAtlasSprite getAtlasSprite(ResourceLocation name) {
        return SPRITE_MAP.computeIfAbsent(name, ModelLoader.defaultTextureGetter());
    }

    public static boolean isClientOP() {
        return ClientUtils.MC.field_71439_g != null && ClientUtils.MC.field_71439_g.func_184840_I() > 0;
    }

    public static boolean isFirstPersonView() {
        return ClientUtils.MC.field_71474_y.field_74320_O == 0;
    }

    public static double getPlayerX() {
        return ClientUtils.MC.func_175598_ae().field_78730_l;
    }

    public static double getPlayerY() {
        return ClientUtils.MC.func_175598_ae().field_78731_m;
    }

    public static double getPlayerZ() {
        return ClientUtils.MC.func_175598_ae().field_78728_n;
    }

    public static double getRenderX() {
        return TileEntityRendererDispatcher.field_147554_b;
    }

    public static double getRenderY() {
        return TileEntityRendererDispatcher.field_147555_c;
    }

    public static double getRenderZ() {
        return TileEntityRendererDispatcher.field_147552_d;
    }

    @Nullable
    public static <T> T getGuiAs(GuiScreen gui, Class<T> clazz) {
        GuiBase guiBase;
        if (gui instanceof IGuiWrapper && clazz.isAssignableFrom((guiBase = ((IGuiWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? ClientUtils.MC.field_71462_r : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return ClientUtils.MC.field_71462_r == null ? null : (T)ClientUtils.getGuiAs(ClientUtils.MC.field_71462_r, clazz);
    }
}

