/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.world;

import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.roots.ConfigManager;
import teamroots.roots.RegistryManager;
import teamroots.roots.entity.EntityBarrow;
import teamroots.roots.network.PacketHandler;
import teamroots.roots.network.message.MessageTEUpdate;
import teamroots.roots.util.Misc;
import teamroots.roots.util.NoiseGenUtil;
import teamroots.roots.world.StructureBase;

public class WorldGenBarrow
extends StructureBase
implements IWorldGenerator {
    public WorldGenBarrow() {
        super(9, 9);
        this.addBlockMapping("c", Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.addBlockMapping("C", Blocks.field_150347_e.func_176223_P());
        this.addBlockMapping("T", RegistryManager.thatch.func_176223_P());
        this.addBlockMapping("W", Blocks.field_150463_bK.func_176223_P());
        this.addBlockMapping("M", Blocks.field_150341_Y.func_176223_P());
        this.addBlockMapping(" ", Blocks.field_150350_a.func_176223_P());
        this.addBlockMapping("A", RegistryManager.structure_marker.func_176203_a(0));
        this.addBlockMapping("L", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.WEST));
        this.addBlockMapping("l", Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
        this.addLayer(new String[]{"   MMM   ", "  CMMMM  ", " MMCMMCM ", "MMCCCMCCM", "MCCCCMCMC", "MMCMCMMCM", " MCMCMMM ", "  MCCCM  ", "   CMM   "});
        this.addLayer(new String[]{"   MMM   ", "  ClAAM  ", " MAAAAlM ", "MAAAAAAAM", "MAAAWAAAC", "MLAAAAAAM", " MAAAAAM ", "  MAALM  ", "   CMM   "});
        this.addLayer(new String[]{"   CCM   ", "  CAAAM  ", " MAAAAAM ", "CAAAAAAAC", "MAAAWAAAC", "CAAAAAAAC", " CAAAAAM ", "  CAAAC  ", "   CCM   "});
        this.addLayer(new String[]{"   CCC   ", "  CAAAC  ", " CAAAAAC ", "CAAAWAAAC", "CAAWWWAAC", "CAAAWAAAC", " CAAAAAC ", "  CAAAC  ", "   CCC   "});
        this.addLayer(new String[]{"   cCc   ", "  cTCTc  ", " cTTCAAc ", "cTTTCTATc", "CCCCACCCC", "cTTTCTATc", " cTTCTAc ", "  cACTc  ", "   cCc   "});
        this.addLayer(new String[]{"         ", "    c    ", "    c    ", "    c    ", " ccc ccc ", "    c    ", "    c    ", "    c    ", "         "});
    }

    @Override
    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        super.placeBlock(world, pos, state);
        if (state.func_177230_c() == RegistryManager.structure_marker) {
            world.func_175698_g(pos);
        }
        if (state.func_177230_c() == Blocks.field_150486_ae && world.func_175625_s(pos) != null) {
            TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
            chest.func_189404_a(new ResourceLocation("roots:barrow"), NoiseGenUtil.getSeed((int)world.func_72905_C(), pos.func_177958_n(), pos.func_177952_p()));
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)chest));
            chest.func_70296_d();
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ConfigManager.barrowChance <= 0) {
            return;
        }
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && !world.field_72995_K) {
            int height;
            int xx = chunkX * 16 + 13 + Misc.random.nextInt(6);
            int zz = chunkZ * 16 + 13 + Misc.random.nextInt(6);
            if (random.nextInt(ConfigManager.barrowChance) == 0 && (Math.abs(xx) > 500 || Math.abs(zz) > 500) && (height = world.func_189649_b(xx, zz) - 1) > 0 && world.func_180495_p(new BlockPos(xx, height, zz)).func_177230_c() instanceof BlockGrass) {
                boolean canGenerate = true;
                for (int i = -2; i < 3; ++i) {
                    for (int j = -2; j < 3; ++j) {
                        if (world.func_180495_p(new BlockPos(xx + i, height, zz + j)).func_177230_c() != Blocks.field_150350_a) continue;
                        canGenerate = false;
                    }
                }
                if (canGenerate) {
                    this.generateIn(world, xx, height - 3, zz);
                    EntityBarrow entity = new EntityBarrow(world);
                    entity.func_70107_b(xx, height - 1, zz);
                    world.func_72838_d((Entity)entity);
                }
            }
        }
    }
}

