/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.util;

import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import teamroots.roots.entity.EntityNatureSpirit;

public class SpiritUtil {
    public static EntityNatureSpirit getClosestSpirit(World world, BlockPos pos) {
        List spirits = world.func_72872_a(EntityNatureSpirit.class, new AxisAlignedBB((double)(pos.func_177958_n() - 128), (double)(pos.func_177956_o() - 256), (double)(pos.func_177952_p() - 128), (double)(pos.func_177958_n() + 128), (double)(pos.func_177956_o() + 256), (double)(pos.func_177952_p() + 128)));
        if (spirits.size() > 0) {
            float minDist = -1.0f;
            int closestSpirit = 0;
            for (int i = 0; i < spirits.size(); ++i) {
                EntityNatureSpirit spirit = (EntityNatureSpirit)((Object)spirits.get(i));
                double distSq = Math.pow(spirit.field_70165_t - ((double)pos.func_177958_n() + 0.5), 2.0) + Math.pow(spirit.field_70163_u - ((double)pos.func_177956_o() + 0.5), 2.0) + Math.pow(spirit.field_70161_v - ((double)pos.func_177952_p() + 0.5), 2.0);
                if (minDist != -1.0f && !(distSq < (double)minDist)) continue;
                minDist = (float)distSq;
                closestSpirit = i;
            }
            if ((double)minDist <= Math.pow(128.0 * Math.min(64.0, (double)SpiritUtil.getPower((EntityNatureSpirit)((Object)spirits.get(closestSpirit)))), 2.0)) {
                return (EntityNatureSpirit)((Object)spirits.get(closestSpirit));
            }
        }
        return null;
    }

    public static float getPower(EntityNatureSpirit spirit) {
        if (spirit != null) {
            return ((Float)spirit.func_184212_Q().func_187225_a(EntityNatureSpirit.natural)).floatValue();
        }
        return 0.0f;
    }

    public static Vec3i getColor() {
        return new Vec3i(177, 255, 117);
    }

    public static EnumAlignment getAlignment(EntityNatureSpirit spirit) {
        return EnumAlignment.NATURAL;
    }

    public static enum EnumAlignment {
        NATURAL;

    }
}

