/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.roots.RegistryManager;
import teamroots.roots.book.Book;
import teamroots.roots.entity.EntityNatureSpirit;
import teamroots.roots.network.PacketHandler;
import teamroots.roots.network.message.MessageTEUpdate;
import teamroots.roots.particle.ParticleUtil;
import teamroots.roots.recipe.LecternScribingRecipe;
import teamroots.roots.recipe.RecipeRegistry;
import teamroots.roots.tileentity.ITileEntityBase;
import teamroots.roots.util.Misc;
import teamroots.roots.util.SpiritUtil;

public class TileEntityLectern
extends TileEntity
implements ITileEntityBase,
ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityLectern.this.func_70296_d();
            if (!((TileEntityLectern)TileEntityLectern.this).field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityLectern.this));
            }
        }
    };
    int progress = -1;
    public float angle = 0.0f;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.progress = tag.func_74762_e("progress");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 0 && this.inventory.getStackInSlot(1).func_190926_b() && !this.inventory.getStackInSlot(0).func_190926_b()) {
                ItemStack toInsert = heldItem.func_77946_l();
                toInsert.func_190920_e(1);
                ItemStack attemptedInsert = this.inventory.insertItem(1, toInsert, true);
                if (attemptedInsert.func_190926_b()) {
                    LecternScribingRecipe recipe;
                    this.inventory.insertItem(1, toInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    if ((recipe = RecipeRegistry.getScribingRecipe(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1))) != null) {
                        this.progress = 0;
                    }
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    return true;
                }
            } else if (this.inventory.getStackInSlot(0).func_190926_b()) {
                ItemStack toInsert = heldItem.func_77946_l();
                toInsert.func_190920_e(1);
                ItemStack attemptedInsert = this.inventory.insertItem(0, toInsert, true);
                if (attemptedInsert.func_190926_b()) {
                    this.inventory.insertItem(0, toInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    return true;
                }
            }
        } else if (player.func_70093_af() && heldItem.func_190926_b()) {
            List spirits = world.func_72872_a(EntityNatureSpirit.class, new AxisAlignedBB((double)(pos.func_177958_n() - 128), (double)(pos.func_177956_o() - 256), (double)(pos.func_177952_p() - 128), (double)(pos.func_177958_n() + 128), (double)(pos.func_177956_o() + 256), (double)(pos.func_177952_p() + 128)));
            if (spirits.size() > 0) {
                float minDist = -1.0f;
                int closestSpirit = 0;
                for (int i = 0; i < spirits.size(); ++i) {
                    EntityNatureSpirit spirit = (EntityNatureSpirit)((Object)spirits.get(i));
                    double distSq = Math.pow(spirit.field_70165_t - ((double)pos.func_177958_n() + 0.5), 2.0) + Math.pow(spirit.field_70163_u - ((double)pos.func_177956_o() + 0.5), 2.0) + Math.pow(spirit.field_70161_v - ((double)pos.func_177952_p() + 0.5), 2.0);
                    if (minDist != -1.0f && !(distSq < (double)minDist)) continue;
                    minDist = (float)distSq;
                    closestSpirit = i;
                }
                EntityNatureSpirit spirit = (EntityNatureSpirit)((Object)spirits.get(closestSpirit));
                ItemStack book = this.inventory.getStackInSlot(0);
                if (book.func_77973_b() == RegistryManager.book_base || book.func_77973_b() == RegistryManager.ritual_book && SpiritUtil.getAlignment(spirit) == SpiritUtil.EnumAlignment.NATURAL) {
                    this.progress = 200;
                    this.func_70296_d();
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    return true;
                }
            }
        } else if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            for (int i = 1; i >= 0; --i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ItemStack extracted = this.inventory.extractItem(i, 1, false);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, extracted));
                }
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                return true;
            }
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Misc.spawnInventoryInWorld(world, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (IItemHandler)this.inventory);
        }
    }

    public void func_73660_a() {
        block11: {
            EntityNatureSpirit spirit;
            this.angle += 1.0f;
            if (this.progress > 0) {
                --this.progress;
                if (this.progress <= 0) {
                    this.progress = -1;
                    ItemStack book = ItemStack.field_190927_a;
                    EntityNatureSpirit spirit2 = SpiritUtil.getClosestSpirit(this.field_145850_b, this.func_174877_v());
                    if (this.inventory.getStackInSlot(0).func_77973_b() == RegistryManager.book_base) {
                        SpiritUtil.EnumAlignment a = SpiritUtil.getAlignment(spirit2);
                        if (a == SpiritUtil.EnumAlignment.NATURAL) {
                            book = new ItemStack(RegistryManager.ritual_book, 1);
                        }
                    } else {
                        book = this.inventory.getStackInSlot(0).func_77946_l();
                    }
                    Book.createData((ItemStack)book, (float)Math.max(Book.getKnowledge((ItemStack)book, (SpiritUtil.EnumAlignment)SpiritUtil.EnumAlignment.NATURAL), SpiritUtil.getPower(spirit2)), (float)0.0f, (float)0.0f, (float)0.0f);
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.125f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), book));
                    }
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                }
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
            }
            if (!this.field_145850_b.field_72995_K || this.progress <= 0 || (spirit = SpiritUtil.getClosestSpirit(this.field_145850_b, this.func_174877_v())) == null) break block11;
            Vec3i color = SpiritUtil.getColor();
            BlockPos pos = this.field_145850_b.func_175672_r(this.func_174877_v().func_177982_a(Misc.random.nextInt(17) - 8, 0, Misc.random.nextInt(17) - 8));
            ParticleUtil.spawnParticleLineRune(this.field_145850_b, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.125f, (float)this.func_174877_v().func_177952_p() + 0.5f, color.func_177958_n(), color.func_177956_o(), color.func_177952_p(), 1.0f, 2.0f + 2.0f * Misc.random.nextFloat(), 75);
            if (this.progress > 1) {
                float pitch = Misc.random.nextFloat() * 360.0f;
                float yaw = Misc.random.nextFloat() * 360.0f;
                for (float i = 0.0f; i < 0.5f; i += 0.05f) {
                    float tx = (float)this.func_174877_v().func_177958_n() + 0.5f + i * (float)Math.sin(Math.toRadians(yaw)) * (float)Math.sin(Math.toRadians(pitch));
                    float ty = (float)this.func_174877_v().func_177956_o() + 1.125f + i * (float)Math.cos(Math.toRadians(pitch));
                    float tz = (float)this.func_174877_v().func_177952_p() + 0.5f + i * (float)Math.cos(Math.toRadians(yaw)) * (float)Math.sin(Math.toRadians(pitch));
                    float coeff = i / 0.5f;
                    ParticleUtil.spawnParticleGlow(this.field_145850_b, tx, ty, tz, 0.0f, 0.0f, 0.0f, color.func_177958_n(), color.func_177956_o(), color.func_177952_p(), 0.5f * (1.0f - coeff), 3.0f * (1.0f - coeff), 20);
                }
            } else {
                for (int j = 0; j < 4; ++j) {
                    float pitch = Misc.random.nextFloat() * 360.0f;
                    float yaw = Misc.random.nextFloat() * 360.0f;
                    for (float i = 0.0f; i < 1.25f; i += 0.125f) {
                        float tx = (float)this.func_174877_v().func_177958_n() + 0.5f + i * (float)Math.sin(Math.toRadians(yaw)) * (float)Math.sin(Math.toRadians(pitch));
                        float ty = (float)this.func_174877_v().func_177956_o() + 1.125f + i * (float)Math.cos(Math.toRadians(pitch));
                        float tz = (float)this.func_174877_v().func_177952_p() + 0.5f + i * (float)Math.cos(Math.toRadians(yaw)) * (float)Math.sin(Math.toRadians(pitch));
                        float coeff = i / 1.25f;
                        ParticleUtil.spawnParticleGlow(this.field_145850_b, tx, ty, tz, 0.0f, 0.0f, 0.0f, color.func_177958_n(), color.func_177956_o(), color.func_177952_p(), 0.25f * (1.0f - coeff), 8.0f * (1.0f - coeff), 80);
                    }
                    ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.125f, (float)this.func_174877_v().func_177952_p() + 0.5f, 0.0625f * (Misc.random.nextFloat() - 0.5f), 0.03125f * Misc.random.nextFloat(), 0.0625f * (Misc.random.nextFloat() - 0.5f), color.func_177958_n(), color.func_177956_o(), color.func_177952_p(), 1.0f, 2.0f, 90);
                }
            }
        }
    }
}

