/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class MoonlightRecipe {
    public IBlockState coreState;
    public IBlockStateCondition coreCondition;
    public List<IBlockState> outerStates = new ArrayList<IBlockState>();
    public List<IBlockStateCondition> outerConditions = new ArrayList<IBlockStateCondition>();
    public IBlockState resultState;

    public MoonlightRecipe(IBlockState core, IBlockStateCondition coreCond, IBlockState outer1, IBlockStateCondition outer1Cond, IBlockState outer2, IBlockStateCondition outer2Cond, IBlockState outer3, IBlockStateCondition outer3Cond, IBlockState outer4, IBlockStateCondition outer4Cond, IBlockState result) {
        this.coreState = core;
        this.coreCondition = coreCond;
        this.outerStates.add(outer1);
        this.outerStates.add(outer2);
        this.outerStates.add(outer3);
        this.outerStates.add(outer4);
        this.outerConditions.add(outer1Cond);
        this.outerConditions.add(outer2Cond);
        this.outerConditions.add(outer3Cond);
        this.outerConditions.add(outer4Cond);
        this.resultState = result;
    }

    public boolean matches(IBlockState core, IBlockState outer1, IBlockState outer2, IBlockState outer3, IBlockState outer4) {
        ArrayList<IBlockState> temp = new ArrayList<IBlockState>();
        ArrayList<IBlockStateCondition> conditions = new ArrayList<IBlockStateCondition>();
        temp.add(this.coreState);
        for (IBlockState iBlockState : this.outerStates) {
            if (iBlockState == null) continue;
            temp.add(iBlockState);
        }
        conditions.add(this.coreCondition);
        for (IBlockStateCondition iBlockStateCondition : this.outerConditions) {
            if (iBlockStateCondition == null) continue;
            conditions.add(iBlockStateCondition);
        }
        ArrayList<IBlockState> inputs = new ArrayList<IBlockState>();
        inputs.add(core);
        inputs.add(outer1);
        inputs.add(outer2);
        inputs.add(outer3);
        inputs.add(outer4);
        if (inputs.size() == temp.size()) {
            int i;
            boolean[] blArray = new boolean[temp.size()];
            boolean[] matches2 = new boolean[inputs.size()];
            for (int i2 = 0; i2 < temp.size(); ++i2) {
                for (int j = 0; j < inputs.size(); ++j) {
                    if (blArray[i2] || matches2[j] || ((IBlockState)temp.get(i2)).func_177230_c() != ((IBlockState)inputs.get(j)).func_177230_c() || !((IBlockStateCondition)conditions.get(i2)).match((IBlockState)temp.get(i2), (IBlockState)inputs.get(j))) continue;
                    blArray[i2] = true;
                    matches2[j] = true;
                }
            }
            boolean doMatch = true;
            for (i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                doMatch = false;
            }
            for (i = 0; i < matches2.length; ++i) {
                if (matches2[i]) continue;
                doMatch = false;
            }
            return doMatch;
        }
        return false;
    }

    public static class ConditionMetaMatch
    implements IBlockStateCondition {
        @Override
        public boolean match(IBlockState state1, IBlockState state2) {
            return state1.func_177230_c().func_176201_c(state1) == state2.func_177230_c().func_176201_c(state2);
        }
    }

    public static class ConditionPropertyMatch
    implements IBlockStateCondition {
        public IProperty property;

        public ConditionPropertyMatch(IProperty property) {
            this.property = property;
        }

        @Override
        public boolean match(IBlockState state1, IBlockState state2) {
            return state1.func_177229_b(this.property) == state2.func_177229_b(this.property);
        }
    }

    public static class ConditionAlways
    implements IBlockStateCondition {
        @Override
        public boolean match(IBlockState state1, IBlockState state2) {
            return true;
        }
    }

    public static interface IBlockStateCondition {
        public boolean match(IBlockState var1, IBlockState var2);
    }
}

