/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.item.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TileEntityApiary
extends TileEntity
implements ITickable {
    public int runTime = 0;
    public int currentBeeRunTime = 0;
    public int produceTime = 0;
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEMS_CAP;
    private final ItemStackHandler itemstackhandler = new ItemStackHandler(19);
    private final RangedWrapper top = new RangedWrapper((IItemHandlerModifiable)this.itemstackhandler, 18, 19);
    private final RangedWrapper bottom = new RangedWrapper((IItemHandlerModifiable)this.itemstackhandler, 0, 18){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };

    public ItemStackHandler getInventory() {
        return this.itemstackhandler;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            if (facing == EnumFacing.UP) {
                return (T)this.top;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.bottom;
            }
            if (facing != null) {
                return (T)this.top;
            }
            return (T)this.itemstackhandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ITEMS_CAP.readNBT((Object)this.itemstackhandler, null, compound.func_74781_a("Items"));
        this.runTime = compound.func_74765_d("RunTime");
        this.produceTime = compound.func_74765_d("ProduceTime");
        this.currentBeeRunTime = this.getRunTime(this.itemstackhandler.getStackInSlot(1));
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("RunTime", (short)this.runTime);
        compound.func_74777_a("ProduceTime", (short)this.produceTime);
        compound.func_74782_a("Items", ITEMS_CAP.writeNBT((Object)this.itemstackhandler, null));
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        boolean isRunning = this.runTime > 0;
        boolean needsUpdate = false;
        if (isRunning) {
            --this.runTime;
        }
        ItemStack queenBee = this.itemstackhandler.getStackInSlot(18);
        if (!this.field_145850_b.field_72995_K) {
            if (this.runTime == 0 && this.canRun()) {
                this.currentBeeRunTime = this.runTime = this.getRunTime(queenBee);
                if (this.runTime > 0) {
                    needsUpdate = true;
                    if (!queenBee.func_190926_b()) {
                        queenBee.func_96631_a(1, this.func_145831_w().field_73012_v, null);
                    }
                }
            }
            if (this.canRun()) {
                ++this.produceTime;
                if ((double)this.produceTime >= Math.floor(this.getRunTime(queenBee))) {
                    this.produceTime = 0;
                    this.run();
                    needsUpdate = true;
                }
            } else {
                this.produceTime = 0;
            }
            if (isRunning != this.runTime > 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
        }
    }

    private boolean canRun() {
        return !this.itemstackhandler.getStackInSlot(18).func_190926_b() && this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.queenbeeItem;
    }

    private void run() {
        this.itemstackhandler.getStackInSlot(18).func_96631_a(1, this.field_145850_b.field_73012_v, null);
        ItemStack itemProduced = this.getComb();
        if (itemProduced.func_190926_b()) {
            return;
        }
        for (int i = 0; i < 18; ++i) {
            if (!this.itemstackhandler.getStackInSlot(i).func_190926_b()) continue;
            this.itemstackhandler.setStackInSlot(i, itemProduced.func_77946_l());
            break;
        }
    }

    private ItemStack getComb() {
        int randomNum = this.field_145850_b.field_73012_v.nextInt(100);
        if (HarvestCraft.config.queenbeelastresultequalsQueen) {
            if (!this.itemstackhandler.getStackInSlot(18).func_190926_b()) {
                if (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.queenbeeItem && this.itemstackhandler.getStackInSlot(18).func_77952_i() == 36) {
                    this.itemstackhandler.getStackInSlot(18).func_190918_g(1);
                    return new ItemStack(ItemRegistry.queenbeeItem);
                }
                if (randomNum < 35) {
                    return new ItemStack(ItemRegistry.waxcombItem);
                }
                if (randomNum >= 35 && randomNum < 70) {
                    return new ItemStack(ItemRegistry.honeycombItem);
                }
                return new ItemStack(ItemRegistry.grubItem);
            }
        } else if (!this.itemstackhandler.getStackInSlot(18).func_190926_b()) {
            if (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.queenbeeItem && this.itemstackhandler.getStackInSlot(18).func_77952_i() == 36) {
                this.itemstackhandler.getStackInSlot(18).func_190918_g(1);
                if (randomNum < 35) {
                    return new ItemStack(ItemRegistry.waxcombItem);
                }
                if (randomNum >= 35 && randomNum < 70) {
                    return new ItemStack(ItemRegistry.honeycombItem);
                }
                return new ItemStack(ItemRegistry.grubItem);
            }
            if (randomNum < 35) {
                return new ItemStack(ItemRegistry.waxcombItem);
            }
            if (randomNum >= 35 && randomNum < 70) {
                return new ItemStack(ItemRegistry.honeycombItem);
            }
            return new ItemStack(ItemRegistry.grubItem);
        }
        return null;
    }

    private int getRunTime(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.queenbeeItem) {
            return this.getRunTime();
        }
        return 0;
    }

    private int getRunTime() {
        int radius = 2;
        int varX = this.field_174879_c.func_177958_n();
        int varY = this.field_174879_c.func_177956_o();
        int varZ = this.field_174879_c.func_177952_p();
        int speed = 3500;
        for (int offsetX = -2; offsetX <= 2; ++offsetX) {
            for (int offsetZ = -2; offsetZ <= 2; ++offsetZ) {
                BlockPos pos;
                if (offsetX * offsetX + offsetZ * offsetZ > 4 || offsetX == -3 && offsetZ == -3 || offsetX == 1 && offsetZ == 1 || offsetX == 1 && offsetZ == -3 || offsetX == -3 && offsetZ == 1 || !this.field_145850_b.func_175667_e(pos = new BlockPos(varX + offsetX, varY, varZ + offsetZ))) continue;
                Block blockAtCoords = this.field_145850_b.func_180495_p(pos).func_177230_c();
                if (blockAtCoords instanceof BlockFlower || blockAtCoords instanceof BlockCrops || blockAtCoords instanceof BlockBaseGarden) {
                    speed = (int)((double)speed * 0.85);
                }
                if (blockAtCoords != BlockRegistry.apiary) continue;
                speed = (int)((double)speed / 1.0);
            }
        }
        return speed;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public String getGuiID() {
        return "harvestcraft:apiary";
    }
}

