/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.item;

import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PresserRecipes {
    private static final Map<ItemStack, ItemStack[]> pressingList = new HashMap<ItemStack, ItemStack[]>();

    private static void registerItemRecipe(Item input, Item leftItem, Item rightItem) {
        ItemStack outputLeft = leftItem != null ? new ItemStack(leftItem) : ItemStack.field_190927_a;
        ItemStack outputRight = rightItem != null ? new ItemStack(rightItem) : ItemStack.field_190927_a;
        PresserRecipes.makeItemStackRecipe(new ItemStack(input, 1, Short.MAX_VALUE), outputLeft, outputRight);
    }

    private static void registerBlockRecipe(Block input, Item leftItem, Item rightItem) {
        PresserRecipes.registerItemRecipe(Item.func_150898_a((Block)input), leftItem, rightItem);
    }

    private static void makeItemStackRecipe(ItemStack input, ItemStack outputLeft, ItemStack outputRight) {
        ItemStack[] outputs = new ItemStack[]{outputLeft, outputRight};
        pressingList.put(input, outputs);
    }

    public static ItemStack[] getPressingResult(ItemStack input) {
        for (Map.Entry<ItemStack, ItemStack[]> entry : pressingList.entrySet()) {
            if (!PresserRecipes.isSameItem(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isSameItem(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == stack.func_77973_b() && (stack2.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == stack.func_77952_i());
    }

    static {
        PresserRecipes.registerItemRecipe(ItemRegistry.waxcombItem, ItemRegistry.beeswaxItem, ItemRegistry.beeswaxItem);
        PresserRecipes.registerItemRecipe(ItemRegistry.honeycombItem, ItemRegistry.honeyItem, ItemRegistry.beeswaxItem);
        PresserRecipes.registerItemRecipe(Items.field_151034_e, ItemRegistry.applejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(ItemRegistry.harvestappleItem, ItemRegistry.applejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(Items.field_151172_bF, ItemRegistry.carrotjuiceItem, ItemRegistry.veggiebaitItem);
        PresserRecipes.registerItemRecipe((Item)ItemRegistry.harvestcarrotItem, ItemRegistry.carrotjuiceItem, ItemRegistry.veggiebaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("blackberry"), ItemRegistry.blackberryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("raspberry"), ItemRegistry.raspberryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("blueberry"), ItemRegistry.blueberryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("cactusfruit"), ItemRegistry.cactusfruitjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("cherry"), ItemRegistry.cherryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("cranberry"), ItemRegistry.cranberryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("grape"), ItemRegistry.grapejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("kiwi"), ItemRegistry.kiwijuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("lime"), ItemRegistry.limejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("mango"), ItemRegistry.mangojuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("plum"), ItemRegistry.plumjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("pear"), ItemRegistry.pearjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("apricot"), ItemRegistry.apricotjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("fig"), ItemRegistry.figjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("grapefruit"), ItemRegistry.grapefruitjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("persimmon"), ItemRegistry.persimmonjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("orange"), ItemRegistry.orangejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("papaya"), ItemRegistry.papayajuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("peach"), ItemRegistry.peachjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("pomegranate"), ItemRegistry.pomegranatejuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("starfruit"), ItemRegistry.starfruitjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("strawberry"), ItemRegistry.strawberryjuiceItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("olive"), ItemRegistry.oliveoilItem, ItemRegistry.fruitbaitItem);
        PresserRecipes.registerItemRecipe(ItemRegistry.sunflowerseedsItem, ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("walnut"), ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(CropRegistry.getSeed("mustardseeds"), ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("avocado"), ItemRegistry.oliveoilItem, ItemRegistry.veggiebaitItem);
        PresserRecipes.registerItemRecipe(CropRegistry.getSeed("cotton"), ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerBlockRecipe(Blocks.field_150423_aK, ItemRegistry.oliveoilItem, ItemRegistry.veggiebaitItem);
        PresserRecipes.registerItemRecipe(Items.field_151080_bb, ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("tealeaf"), ItemRegistry.oliveoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(CropRegistry.getSeed("sesameseeds"), ItemRegistry.sesameoilItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(Items.field_151120_aE, Items.field_151102_aT, Items.field_151102_aT);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("beet"), Items.field_151102_aT, ItemRegistry.veggiebaitItem);
        PresserRecipes.registerBlockRecipe(Blocks.field_150364_r, Items.field_151121_aF, Items.field_151121_aF);
        PresserRecipes.registerBlockRecipe(Blocks.field_150363_s, Items.field_151121_aF, Items.field_151121_aF);
        PresserRecipes.registerItemRecipe(ItemRegistry.freshwaterItem, ItemRegistry.bubblywaterItem, ItemRegistry.bubblywaterItem);
        PresserRecipes.registerItemRecipe((Item)CropRegistry.getFood("soybean"), ItemRegistry.silkentofuItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(ItemRegistry.silkentofuItem, ItemRegistry.firmtofuItem, ItemRegistry.soymilkItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("almond"), ItemRegistry.freshmilkItem, ItemRegistry.grainbaitItem);
        PresserRecipes.registerItemRecipe(FruitRegistry.getFood("coconut"), ItemRegistry.coconutmilkItem, ItemRegistry.veggiebaitItem);
    }
}

