/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks.blocks;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.worldgen.WorldGenHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBaseGarden
extends BlockBush {
    public static final Map<String, List<ItemStack>> drops = new HashMap<String, List<ItemStack>>();
    private final String type;
    private final String name;
    private final Region region;

    public BlockBaseGarden(String type, Region region) {
        super(Material.field_151577_b);
        this.type = type;
        this.name = type.toLowerCase();
        this.region = region;
        this.func_149647_a(HarvestCraft.modTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        BlockRegistry.registerBlock(this.name, (Block)this);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (HarvestCraft.config.enablegardenSpread && rand.nextInt(100 - HarvestCraft.config.gardenspreadRate) == 0) {
            int amount = HarvestCraft.config.gardenSpreadMax;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_175667_e(blockpos) && worldIn.func_180495_p(blockpos).func_177230_c() != this || --amount > 0) continue;
                return;
            }
            BlockPos newGardenPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175667_e(newGardenPos) && this.func_176196_c(worldIn, newGardenPos) && this.func_180671_f(worldIn, newGardenPos, this.func_176223_P())) {
                    pos = newGardenPos;
                }
                newGardenPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (worldIn.func_175667_e(newGardenPos) && this.func_176196_c(worldIn, newGardenPos) && this.func_180671_f(worldIn, newGardenPos, this.func_176223_P())) {
                worldIn.func_180501_a(newGardenPos, this.func_176223_P(), 2);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        return WorldGenHelper.canReplace(blockState, worldIn, pos) && this.checkSoilBlock(worldIn, pos);
    }

    private boolean checkSoilBlock(World world, BlockPos pos) {
        Block soilBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        for (Block acceptableBlock : this.region.getSoilBlocks()) {
            if (acceptableBlock != soilBlock) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.region.getPlantType();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public String getName() {
        return this.name;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (player.func_70093_af() || this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockBaseGarden.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> newStack = new ArrayList<ItemStack>();
        List<ItemStack> ourDrops = drops.get(this.type);
        Collections.shuffle(ourDrops);
        int len = Math.min(HarvestCraft.config.gardendropAmount, ourDrops.size());
        for (int i = 0; i < len; ++i) {
            ItemStack drop = ourDrops.get(i);
            if (drop == null) {
                System.err.println("Tried to get a null item for garden '" + this.type + "'.");
                continue;
            }
            newStack.add(drop.func_77946_l());
        }
        return newStack;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public static enum Region {
        PLAINS(EnumPlantType.Plains, new Block[]{Blocks.field_150349_c, Blocks.field_150346_d}),
        DESERT(EnumPlantType.Desert, new Block[]{Blocks.field_150354_m});

        private final EnumPlantType plantType;
        private final Block[] soilBlocks;

        private Region(EnumPlantType plantType, Block ... soilBlocks) {
            this.plantType = plantType;
            this.soilBlocks = soilBlocks;
        }

        public EnumPlantType getPlantType() {
            return this.plantType;
        }

        public Block[] getSoilBlocks() {
            return this.soilBlocks;
        }
    }
}

