/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.item.ItemRegistry;
import com.pam.harvestcraft.item.items.ItemPamFood;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLLog;

public class FruitRegistry {
    private static final String FRUIT_BLOCK_NAME = "pam{0}";
    private static final String ITEM_NAME = "{0}item";
    private static final String SAPLING_NAME = "{0}_sapling";
    public static final String APPLE = "apple";
    public static final String ALMOND = "almond";
    public static final String APRICOT = "apricot";
    public static final String AVOCADO = "avocado";
    public static final String BANANA = "banana";
    public static final String CASHEW = "cashew";
    public static final String CHERRY = "cherry";
    public static final String CHESTNUT = "chestnut";
    public static final String COCONUT = "coconut";
    public static final String DATE = "date";
    public static final String DRAGONFRUIT = "dragonfruit";
    public static final String DURIAN = "durian";
    public static final String FIG = "fig";
    public static final String GOOSEBERRY = "gooseberry";
    public static final String GRAPEFRUIT = "grapefruit";
    public static final String LEMON = "lemon";
    public static final String LIME = "lime";
    public static final String MANGO = "mango";
    public static final String NUTMEG = "nutmeg";
    public static final String OLIVE = "olive";
    public static final String ORANGE = "orange";
    public static final String PAPAYA = "papaya";
    public static final String PEACH = "peach";
    public static final String PEAR = "pear";
    public static final String PECAN = "pecan";
    public static final String PEPPERCORN = "peppercorn";
    public static final String PERSIMMON = "persimmon";
    public static final String PISTACHIO = "pistachio";
    public static final String PLUM = "plum";
    public static final String POMEGRANATE = "pomegranate";
    public static final String STARFRUIT = "starfruit";
    public static final String VANILLABEAN = "vanillabean";
    public static final String WALNUT = "walnut";
    public static final String SPIDERWEB = "spiderweb";
    public static final String CINNAMON = "cinnamon";
    public static final String MAPLE = "maple";
    public static final String PAPERBARK = "paperbark";
    public static final HashMap<String, BlockPamSapling.SaplingType> registeringFruits = new HashMap();
    public static final HashMap<String, BlockPamSapling.SaplingType> registeringLogFruits = new HashMap();
    private static boolean isInitialised;
    public static final HashMap<String, BlockPamSapling> temperateSaplings;
    public static final HashMap<String, BlockPamSapling> warmSaplings;
    public static final HashMap<String, BlockPamSapling> logSaplings;
    public static final HashMap<String, BlockPamSapling> coldSaplings;
    private static final HashMap<String, BlockPamSapling> saplings;
    public static final HashSet<BlockPamFruit> fruits;
    public static final HashMap<String, BlockPamFruitLog> logs;
    public static final HashMap<String, Item> foodItems;

    public static Collection<BlockPamSapling> getSaplings() {
        if (!isInitialised) {
            FMLLog.bigWarning((String)"FruitRegistry has not been initialised yet.", (Object[])new Object[0]);
            return new HashSet<BlockPamSapling>();
        }
        return saplings.values();
    }

    public static BlockPamSapling getSapling(String fruitName) {
        if (!isInitialised) {
            FMLLog.bigWarning((String)"FruitRegistry has not been initialised yet.", (Object[])new Object[0]);
            return null;
        }
        if (!saplings.containsKey(fruitName)) {
            FMLLog.bigWarning((String)"%s is not registered in saplings map.", (Object[])new Object[]{fruitName});
            return null;
        }
        return saplings.get(fruitName);
    }

    public static Item getFood(String fruitName) {
        if (!isInitialised) {
            FMLLog.bigWarning((String)"FruitRegistry has not been initialised yet.", (Object[])new Object[0]);
            return null;
        }
        if (!foodItems.containsKey(fruitName)) {
            FMLLog.bigWarning((String)"%s is not registered in food map.", (Object[])new Object[]{fruitName});
            return null;
        }
        return foodItems.get(fruitName);
    }

    public static BlockPamFruitLog getLog(String fruitName) {
        if (!isInitialised) {
            FMLLog.bigWarning((String)"FruitRegistry has not been initialised yet.", (Object[])new Object[0]);
            return null;
        }
        if (!logs.containsKey(fruitName)) {
            FMLLog.bigWarning((String)"%s is not registered in log fruit map.", (Object[])new Object[]{fruitName});
            return null;
        }
        return logs.get(fruitName);
    }

    public static void registerFruits() {
        if (isInitialised) {
            return;
        }
        for (Map.Entry<String, BlockPamSapling.SaplingType> entry : registeringFruits.entrySet()) {
            FruitRegistry.registerFruit(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, BlockPamSapling.SaplingType> entry : registeringLogFruits.entrySet()) {
            FruitRegistry.registerLogFruit(entry.getKey(), entry.getValue());
        }
        saplings.putAll(temperateSaplings);
        saplings.putAll(warmSaplings);
        saplings.putAll(coldSaplings);
        saplings.putAll(logSaplings);
        isInitialised = true;
    }

    private static void registerFruit(String fruitName, BlockPamSapling.SaplingType saplingType) {
        BlockPamFruit pamFruit;
        String saplingName = MessageFormat.format(SAPLING_NAME, fruitName);
        BlockPamSapling sapling = new BlockPamSapling(saplingName, saplingType);
        ItemBlock saplingItemBlock = new ItemBlock((Block)sapling);
        BlockRegistry.registerBlock(saplingName, saplingItemBlock, (Block)sapling);
        if (saplingType.equals((Object)BlockPamSapling.SaplingType.TEMPERATE)) {
            temperateSaplings.put(fruitName, sapling);
        } else if (saplingType.equals((Object)BlockPamSapling.SaplingType.WARM)) {
            warmSaplings.put(fruitName, sapling);
        }
        if (fruitName.equals(APPLE)) {
            pamFruit = new BlockPamFruit(sapling, Items.field_151034_e);
            foodItems.put(fruitName, Items.field_151034_e);
        } else if (fruitName.equals(SPIDERWEB)) {
            pamFruit = new BlockPamFruit(sapling, Items.field_151007_F);
            foodItems.put(fruitName, Items.field_151007_F);
        } else {
            ItemPamFood foodItem = new ItemPamFood(HarvestCraft.config.cropfoodRestore, HarvestCraft.config.snacksaturation);
            foodItems.put(fruitName, (Item)foodItem);
            Item fruit = ItemRegistry.registerItem((Item)foodItem, FruitRegistry.getItemName(fruitName));
            pamFruit = new BlockPamFruit(sapling, fruit);
            fruits.add(pamFruit);
        }
        sapling.setFruit(pamFruit);
        BlockRegistry.registerBlock(FruitRegistry.getFruitBlockName(fruitName), new ItemBlock((Block)pamFruit), pamFruit);
    }

    private static String getFruitBlockName(String fruitName) {
        return MessageFormat.format(FRUIT_BLOCK_NAME, fruitName);
    }

    private static String getItemName(String fruitName) {
        if (fruitName.equals(MAPLE)) {
            return "maplesyrupitem";
        }
        return MessageFormat.format(ITEM_NAME, fruitName);
    }

    private static void registerLogFruit(String fruitName, BlockPamSapling.SaplingType saplingType) {
        BlockPamFruitLog logFruit;
        fruitName.toLowerCase(Locale.ROOT);
        String saplingName = MessageFormat.format(SAPLING_NAME, fruitName);
        BlockPamSapling sapling = new BlockPamSapling(saplingName, saplingType);
        ItemBlock saplingItemBlock = new ItemBlock((Block)sapling);
        BlockRegistry.registerBlock(saplingName, saplingItemBlock, (Block)sapling);
        if (saplingType.equals((Object)BlockPamSapling.SaplingType.TEMPERATE)) {
            temperateSaplings.put(fruitName, sapling);
        } else if (saplingType.equals((Object)BlockPamSapling.SaplingType.WARM)) {
            warmSaplings.put(fruitName, sapling);
        } else if (saplingType.equals((Object)BlockPamSapling.SaplingType.COLD)) {
            coldSaplings.put(fruitName, sapling);
        }
        logSaplings.put(fruitName, sapling);
        if (fruitName.equals(PAPERBARK)) {
            logFruit = new BlockPamFruitLog(sapling, Items.field_151121_aF);
            foodItems.put(fruitName, Items.field_151121_aF);
        } else {
            ItemPamFood item = new ItemPamFood(HarvestCraft.config.cropfoodRestore, HarvestCraft.config.snacksaturation);
            foodItems.put(fruitName, (Item)item);
            Item fruit = ItemRegistry.registerItem((Item)item, FruitRegistry.getItemName(fruitName));
            logFruit = new BlockPamFruitLog(sapling, fruit);
        }
        logs.put(fruitName, logFruit);
        sapling.setFruit(logFruit);
        BlockRegistry.registerBlock(FruitRegistry.getFruitBlockName(fruitName), new ItemBlock((Block)logFruit), logFruit);
    }

    static {
        registeringFruits.put(APPLE, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(ALMOND, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(APRICOT, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(AVOCADO, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(BANANA, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(CASHEW, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(CHERRY, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(CHESTNUT, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(COCONUT, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(DATE, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(DRAGONFRUIT, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(DURIAN, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(FIG, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(GOOSEBERRY, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(GRAPEFRUIT, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(LEMON, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(LIME, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(MANGO, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(NUTMEG, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(OLIVE, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(ORANGE, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PAPAYA, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PEACH, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PEAR, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(PECAN, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PEPPERCORN, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PERSIMMON, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PISTACHIO, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(PLUM, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(POMEGRANATE, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(STARFRUIT, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(VANILLABEAN, BlockPamSapling.SaplingType.WARM);
        registeringFruits.put(WALNUT, BlockPamSapling.SaplingType.TEMPERATE);
        registeringFruits.put(SPIDERWEB, BlockPamSapling.SaplingType.TEMPERATE);
        registeringLogFruits.put(CINNAMON, BlockPamSapling.SaplingType.WARM);
        registeringLogFruits.put(MAPLE, BlockPamSapling.SaplingType.COLD);
        registeringLogFruits.put(PAPERBARK, BlockPamSapling.SaplingType.WARM);
        isInitialised = false;
        temperateSaplings = new HashMap();
        warmSaplings = new HashMap();
        logSaplings = new HashMap();
        coldSaplings = new HashMap();
        saplings = new HashMap();
        fruits = new HashSet();
        logs = new HashMap();
        foodItems = new HashMap();
    }
}

