/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.tiles;

import com.google.common.base.Preconditions;
import forestry.api.genetics.IAllele;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyCocoon;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.NetworkUtil;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCocoon
extends TileEntity
implements IStreamable,
IOwnedTile,
IButterflyCocoon {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private int age;
    private int maturationTime;
    private IButterfly caterpillar = ButterflyDefinition.CabbageWhite.getIndividual();
    private boolean isSolid;

    public TileCocoon() {
    }

    public TileCocoon(boolean isSolid) {
        this.isSolid = isSolid;
        if (isSolid) {
            this.age = 2;
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("Caterpillar")) {
            this.caterpillar = new Butterfly(nbttagcompound.func_74775_l("Caterpillar"));
        }
        this.ownerHandler.readFromNBT(nbttagcompound);
        this.age = nbttagcompound.func_74762_e("Age");
        this.maturationTime = nbttagcompound.func_74762_e("CATMAT");
        this.isSolid = nbttagcompound.func_74767_n("isSolid");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        NBTTagCompound subcompound = new NBTTagCompound();
        this.caterpillar.writeToNBT(subcompound);
        nbttagcompound.func_74782_a("Caterpillar", (NBTBase)subcompound);
        this.ownerHandler.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Age", this.age);
        nbttagcompound.func_74768_a("CATMAT", this.maturationTime);
        nbttagcompound.func_74757_a("isSolid", this.isSolid);
        return nbttagcompound;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        IButterfly caterpillar = this.getCaterpillar();
        String speciesUID = caterpillar.getIdent();
        data.func_180714_a(speciesUID);
        data.writeInt(this.age);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        String speciesUID = data.readString();
        IButterfly caterpillar = TileCocoon.getButterfly(speciesUID);
        this.setCaterpillar(caterpillar);
        this.age = data.readInt();
    }

    private static IButterfly getButterfly(String speciesUID) {
        IAllele[] butterflyTemplate = ButterflyManager.butterflyRoot.getTemplate(speciesUID);
        Preconditions.checkNotNull((Object)butterflyTemplate, (String)"Could not find butterfly template for species: %s", (Object)speciesUID);
        return ButterflyManager.butterflyRoot.templateAsIndividual(butterflyTemplate);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !Block.func_149680_a((Block)oldState.func_177230_c(), (Block)newSate.func_177230_c());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(NBTTagCompound tag) {
        int oldAge = this.age;
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
        if (oldAge != this.age) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public void onBlockTick() {
        ++this.maturationTime;
        IButterflyGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getLifespan() / (float)(caterpillarGenome.getFertility() * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            if (this.age < 2) {
                ++this.age;
                this.maturationTime = 0;
                IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
            } else if (this.caterpillar.canTakeFlight(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())) {
                NonNullList<ItemStack> cocoonDrops = this.caterpillar.getCocoonDrop(this);
                for (ItemStack drop : cocoonDrops) {
                    ItemStackUtil.dropItemStackAsEntity(drop, this.field_145850_b, this.field_174879_c);
                }
                this.field_145850_b.func_175698_g(this.func_174877_v());
                TileCocoon.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.func_174877_v());
            }
        }
    }

    private boolean isListEmpty(NonNullList<ItemStack> cocoonDrops) {
        if (cocoonDrops.isEmpty()) {
            return true;
        }
        for (ItemStack stack : cocoonDrops) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, BlockPos pos) {
        EntityLiving entityLiving = ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), pos.func_177958_n(), (float)pos.func_177956_o() + 0.1f, pos.func_177952_p());
        Log.trace("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    private void sendNetworkUpdate() {
        NetworkUtil.sendNetworkPacket(new PacketTileStream(this), this.field_174879_c, this.field_145850_b);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public NonNullList<ItemStack> getCocoonDrops() {
        return this.caterpillar.getCocoonDrop(this);
    }

    @Override
    public boolean isSolid() {
        return this.isSolid;
    }
}

