/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.climate.IClimateState;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ICamouflageHandler;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.greenhouse.IGreenhouseHousing;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.tiles.ITitled;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.camouflage.CamouflageHandlerType;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.GuiGreenhouse;
import forestry.greenhouse.multiblock.GreenhouseController;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.network.packets.PacketCamouflageSelectionServer;
import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileGreenhouse
extends MultiblockTileEntityForestry<MultiblockLogicGreenhouse>
implements IGreenhouseComponent,
IGreenhouseHousing,
IStreamableGui,
IErrorLogicSource,
IOwnedTile,
ITitled,
ICamouflageHandler,
ICamouflagedTile {
    protected ItemStack camouflageBlock = this.getDefaultCamouflageBlock();

    public TileGreenhouse() {
        super(new MultiblockLogicGreenhouse());
    }

    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, BlockPos minCoord, BlockPos maxCoord) {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
    }

    @Override
    public void onMachineBroken() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        this.func_70296_d();
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            packetData.func_74782_a("Camouflage", (NBTBase)nbtTag);
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("Camouflage")) {
            this.setCamouflageBlock(new ItemStack(packetData.func_74775_l("Camouflage")), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("Camouflage")) {
            this.camouflageBlock = new ItemStack(data.func_74775_l("Camouflage"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (!this.camouflageBlock.func_190926_b()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.camouflageBlock.func_77955_b(nbtTag);
            data.func_74782_a("Camouflage", (NBTBase)nbtTag);
        }
        return data;
    }

    @Override
    public ItemStack getCamouflageBlock() {
        return this.camouflageBlock;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock() {
        return GreenhouseController.createDefaultCamouflageBlock();
    }

    @Override
    public boolean setCamouflageBlock(ItemStack camouflageBlock, boolean sendClientUpdate) {
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflageBlock)) {
            this.camouflageBlock = camouflageBlock;
            if (sendClientUpdate && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                NetworkUtil.sendToServer(new PacketCamouflageSelectionServer(this, CamouflageHandlerType.TILE));
                this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            }
            return true;
        }
        return false;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getErrorLogic();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getOwnerHandler();
    }

    @Override
    public String getUnlocalizedTitle() {
        return "for.gui.greenhouse.title";
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiGreenhouse(player, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerGreenhouse(player.field_71071_by, this);
    }

    @Override
    public int getSize() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getSize();
    }

    @Override
    public void onUpdateClimate() {
        ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().onUpdateClimate();
    }

    @Override
    public IClimateState getDefaultClimate() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getDefaultClimate();
    }

    @Override
    public EnumTemperature getTemperature() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getHumidity();
    }

    @Override
    public float getExactTemperature() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getExactHumidity();
    }
}

