/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.network.packets;

import forestry.api.core.ICamouflageHandler;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.camouflage.CamouflageHandlerType;
import forestry.greenhouse.gui.ContainerCamouflageSprayCan;
import forestry.greenhouse.inventory.ItemInventoryCamouflageSprayCan;
import forestry.greenhouse.network.packets.PacketCamouflageSelection;
import forestry.greenhouse.network.packets.PacketCamouflageSelectionClient;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketCamouflageSelectionServer
extends PacketCamouflageSelection
implements IForestryPacketServer {
    public PacketCamouflageSelectionServer(ICamouflageHandler handler, CamouflageHandlerType handlerType) {
        super(handler, handlerType);
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.CAMOUFLAGE_SELECTION;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            BlockPos pos = data.func_179259_c();
            CamouflageHandlerType handlerType = CamouflageHandlerType.values()[data.readShort()];
            ItemStack camouflageStack = data.func_150791_c();
            TileEntity tile = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos);
            ICamouflageHandler handler = null;
            switch (handlerType) {
                case STRUCTURE: {
                    IMultiblockController controller;
                    if (!(tile instanceof IMultiblockComponent) || !((controller = ((IMultiblockComponent)tile).getMultiblockLogic().getController()) instanceof ICamouflageHandler)) break;
                    handler = (ICamouflageHandler)((Object)controller);
                    break;
                }
                case TILE: {
                    if (!(tile instanceof ICamouflageHandler)) break;
                    handler = (ICamouflageHandler)tile;
                    break;
                }
                case ITEM: {
                    ContainerCamouflageSprayCan container;
                    ItemInventoryCamouflageSprayCan sprayCanInv;
                    Container openContainer = player.field_71070_bA;
                    if (!(openContainer instanceof ContainerCamouflageSprayCan) || (sprayCanInv = (ItemInventoryCamouflageSprayCan)(container = (ContainerCamouflageSprayCan)openContainer).getItemInventory()).func_191420_l()) break;
                    handler = sprayCanInv;
                    break;
                }
            }
            if (handler != null && handler.setCamouflageBlock(camouflageStack, true) && handlerType != CamouflageHandlerType.ITEM) {
                NetworkUtil.sendNetworkPacket(new PacketCamouflageSelectionClient(handler, handlerType), pos, player.field_70170_p);
            }
        }
    }
}

