/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.world;

import forestry.core.utils.Log;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseChunk;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkThread
implements Runnable {
    private final long INTERVAL = 250L;
    private boolean stop = false;
    private boolean isClient;

    public ChunkThread(boolean isClient) {
        this.isClient = isClient;
    }

    @SideOnly(value=Side.CLIENT)
    private static void handleClientWorld() {
        ChunkThread.handleDirtyChunks((World)Minecraft.func_71410_x().field_71441_e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleDirtyChunks(World world) {
        GreenhouseBlockManager manager;
        if (world == null || world.field_73011_w == null) {
            return;
        }
        GreenhouseBlockManager greenhouseBlockManager = manager = GreenhouseBlockManager.getInstance();
        synchronized (greenhouseBlockManager) {
            List<Long> dirtyChunks = manager.getDirtyChunks(world);
            Iterator<Long> dirtyChunksIterator = dirtyChunks.iterator();
            while (dirtyChunksIterator.hasNext()) {
                Long chunkPos = dirtyChunksIterator.next();
                GreenhouseChunk chunk = manager.getChunk(world, chunkPos);
                if (chunk != null) {
                    GreenhouseChunk greenhouseChunk = chunk;
                    synchronized (greenhouseChunk) {
                        Collection<IGreenhouseProvider> providers = chunk.getDirtyProviders();
                        Iterator<IGreenhouseProvider> dirtyProviders = providers.iterator();
                        while (dirtyProviders.hasNext()) {
                            IGreenhouseProvider provider = dirtyProviders.next();
                            provider.recreate();
                            dirtyProviders.remove();
                        }
                    }
                }
                dirtyChunksIterator.remove();
            }
            manager.tickUpdates(world);
        }
    }

    @Override
    public void run() {
        Log.info("Starting greenhouse thread", new Object[0]);
        while (!this.stop) {
            try {
                long startTime = System.currentTimeMillis();
                if (this.isClient) {
                    ChunkThread.handleClientWorld();
                } else {
                    for (WorldServer world : DimensionManager.getWorlds()) {
                        ChunkThread.handleDirtyChunks((World)world);
                    }
                }
                long executionTime = System.currentTimeMillis() - startTime;
                try {
                    if (executionTime > 250L) {
                        Log.warning("GREENHOUSE TAKING " + (executionTime - 250L) + " ms LONGER THAN NORMAL", new Object[0]);
                    }
                    Thread.sleep(Math.max(1L, 250L - executionTime));
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Update Greenhouse change");
                throw new ReportedException(crashreport);
            }
        }
        Log.info("Stopping climate thread", new Object[0]);
        GreenhouseBlockManager.setThread(null, this.isClient);
    }
}

