/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks;

import com.google.common.base.MoreObjects;
import forestry.greenhouse.api.greenhouse.IBlankBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockStorage;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class GreenhouseBlock<P extends IGreenhouseBlock>
implements IGreenhouseBlock {
    protected final BlockPos pos;
    protected final IGreenhouseProvider provider;
    protected final IGreenhouseBlockStorage storage;
    @Nullable
    protected P root;
    @Nullable
    protected EnumFacing rootFace;

    public GreenhouseBlock(IGreenhouseProvider provider, BlockPos pos) {
        this.provider = provider;
        this.storage = provider.getStorage();
        this.pos = pos;
        this.root = null;
        this.rootFace = null;
    }

    public GreenhouseBlock(IGreenhouseProvider provider, BlockPos pos, @Nullable EnumFacing rootFace, @Nullable P root) {
        this.provider = provider;
        this.storage = provider.getStorage();
        this.pos = pos;
        this.root = root;
        this.rootFace = rootFace;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public P getRoot() {
        return this.root;
    }

    public void setRoot(@Nullable P root) {
        this.root = root;
    }

    @Override
    @Nullable
    public EnumFacing getRootFace() {
        return this.rootFace;
    }

    @Override
    public IGreenhouseProvider getProvider() {
        return this.provider;
    }

    @Override
    public void onNeighborRemoved(IBlankBlock changedBlock, EnumFacing facing, boolean forcedRemove, @Nullable Set<IGreenhouseBlock> blocksToCheck) {
    }

    public void setRootFace(@Nullable EnumFacing rootFace) {
        this.rootFace = rootFace;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IGreenhouseBlock)) {
            return false;
        }
        IGreenhouseBlock logicBlock = (IGreenhouseBlock)obj;
        BlockPos blockPos = logicBlock.getPos();
        return this.pos.equals((Object)blockPos);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.pos.func_177958_n()).add("y", this.pos.func_177956_o()).add("z", this.pos.func_177952_p()).toString();
    }
}

