/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock;

import forestry.api.climate.IClimateState;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ICamouflagedTile;
import forestry.api.core.IErrorLogic;
import forestry.api.greenhouse.IGreenhouseListener;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.ModuleCore;
import forestry.core.climate.ClimateStates;
import forestry.core.config.Config;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;
import forestry.greenhouse.api.climate.GreenhouseState;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.IGreenhouseLogic;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.IGreenhouseProviderListener;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.camouflage.CamouflageHandlerType;
import forestry.greenhouse.climate.ClimateContainer;
import forestry.greenhouse.multiblock.GreenhouseLimits;
import forestry.greenhouse.multiblock.GreenhouseMultiblockSizeLimits;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProvider;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProviderClient;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProviderServer;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import forestry.greenhouse.network.packets.PacketCamouflageSelectionServer;
import forestry.greenhouse.network.packets.PacketGreenhouseDataRequest;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GreenhouseController
extends RectangularMultiblockControllerBase
implements IGreenhouseControllerInternal,
IGreenhouseProviderListener {
    public static final String TYPE = "for.multiblock.greenhouse.type";
    public static final int CENTER_HEIGHT = 3;
    public static final int REGION_DEPTH = 6;
    private static final String CAMOUFLAGE_NBT_KEY = "Camouflage";
    private static final String CONTAINER_NBT_KEY = "Container";
    private static final String CENTER_POSITION_NBT_KEY = "Center";
    private final Set<IGreenhouseComponent.Listener> listenerComponents = new HashSet<IGreenhouseComponent.Listener>();
    private final Set<IGreenhouseComponent.Active> activeComponents = new HashSet<IGreenhouseComponent.Active>();
    private final Collection<IGreenhouseLogic> logics;
    private final EnergyManager energyManager;
    private final GreenhouseProvider provider;
    @Nullable
    private IGreenhouseLimits limits;
    private ItemStack camouflage;
    private ClimateContainer climateContainer;
    private IClimateState defaultState = ClimateStates.INSTANCE.min();
    private BlockPos centerPos;
    private int assembleTickCount;
    @SideOnly(value=Side.CLIENT)
    private boolean requestedData;

    public GreenhouseController(World world) {
        super(world, GreenhouseMultiblockSizeLimits.INSTANCE);
        this.energyManager = new EnergyManager(200, 100000);
        this.camouflage = this.getDefaultCamouflageBlock();
        this.climateContainer = new ClimateContainer(this, this::canWork);
        this.centerPos = BlockPos.field_177992_a;
        this.provider = world.field_72995_K ? new GreenhouseProviderClient(world, this.climateContainer) : new GreenhouseProviderServer(world, this.climateContainer);
        this.provider.addListener(this);
        this.logics = GreenhouseManager.helper.createLogics(this);
        for (IGreenhouseLogic logic : this.logics) {
            if (!(logic instanceof IGreenhouseProviderListener)) continue;
            this.provider.addListener((IGreenhouseProviderListener)((Object)logic));
        }
    }

    public static ItemStack createDefaultCamouflageBlock() {
        return new ItemStack((Block)ModuleCore.getBlocks().ashBrick);
    }

    @Override
    public BlockPos getCoordinates() {
        return this.getReferenceCoord();
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        return this.climateContainer.getState().getTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.climateContainer.getState().getHumidity();
    }

    @Override
    public IClimateContainer getClimateContainer() {
        return this.climateContainer;
    }

    @Override
    public int getSize() {
        return this.provider.getSize();
    }

    @Override
    public void onUpdateClimate() {
        if (this.provider instanceof GreenhouseProviderClient) {
            GreenhouseProviderClient providerClient = (GreenhouseProviderClient)this.provider;
            providerClient.markBlockForRenderUpdate();
        }
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.provider.getErrorLogic();
    }

    @Override
    public IClimateState getDefaultClimate() {
        return this.defaultState;
    }

    @Override
    public IGreenhouseProvider getProvider() {
        return this.provider;
    }

    @Override
    public IGreenhouseLimits getLimits() {
        return this.limits;
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public String getUnlocalizedType() {
        return TYPE;
    }

    @Override
    protected void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.add((IGreenhouseComponent.Active)newPart);
        }
        if (newPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.add((IGreenhouseComponent.Listener)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.remove(oldPart);
        }
        if (oldPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.remove(oldPart);
        }
    }

    @Override
    protected void onMachineRestored() {
        super.onMachineRestored();
    }

    @Override
    protected void onMachinePaused() {
        this.provider.clear(true);
        this.provider.getStorage().removeProviderFromChunks();
        this.centerPos = BlockPos.field_177992_a;
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.provider.clear(false);
        this.provider.getStorage().removeProviderFromChunks();
        this.centerPos = BlockPos.field_177992_a;
        for (IMultiblockComponent comp : this.connectedParts) {
            if (!(comp instanceof ICamouflagedTile)) continue;
            this.world.func_175704_b(comp.getCoordinates(), comp.getCoordinates());
        }
        this.limits = null;
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        if (this.provider.getState() == GreenhouseState.UNLOADED) {
            if (this.assembleTickCount + 60 <= tickCount) {
                this.provider.create();
            }
        } else {
            this.climateContainer.updateClimate(tickCount);
            for (IGreenhouseComponent.Active activeComponent : this.activeComponents) {
                activeComponent.updateServer(tickCount);
            }
            for (IGreenhouseLogic logic : this.logics) {
                logic.work(tickCount);
            }
        }
        return false;
    }

    @Override
    protected void updateClient(int tickCount) {
        if (!this.requestedData && this.provider.getState() == GreenhouseState.UNLOADED) {
            NetworkUtil.sendToServer(new PacketGreenhouseDataRequest(this.getReferenceCoord()));
            this.requestedData = true;
        }
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.energyManager.writeData(data);
        data.func_150788_a(this.camouflage);
        this.climateContainer.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.energyManager.readData(data);
        this.camouflage = data.func_150791_c();
        this.climateContainer.readData(data);
    }

    @Override
    public ItemStack getCamouflageBlock() {
        return this.camouflage;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock() {
        return GreenhouseController.createDefaultCamouflageBlock();
    }

    @Override
    public boolean setCamouflageBlock(ItemStack camouflageBlock, boolean sendClientUpdate) {
        if (!ItemStackUtil.isIdenticalItem(camouflageBlock, this.camouflage)) {
            this.camouflage = camouflageBlock;
            if (sendClientUpdate && this.world.field_72995_K) {
                for (IMultiblockComponent comp : this.connectedParts) {
                    if (!(comp instanceof ICamouflagedTile)) continue;
                    ICamouflagedTile camBlock = (ICamouflagedTile)((Object)comp);
                    BlockPos coordinates = camBlock.getCoordinates();
                    this.world.func_175704_b(coordinates, coordinates);
                }
                NetworkUtil.sendToServer(new PacketCamouflageSelectionServer(this, CamouflageHandlerType.STRUCTURE));
            }
            return true;
        }
        return false;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public boolean canWork() {
        boolean canWork = true;
        for (IGreenhouseComponent.Listener listenerComponent : this.listenerComponents) {
            IGreenhouseListener listener = listenerComponent.getGreenhouseListener();
            canWork = listener.canWork(this, canWork);
        }
        return canWork && this.provider.isClosed();
    }

    @Override
    public Set<IGreenhouseComponent.Listener> getListenerComponents() {
        return this.listenerComponents;
    }

    @Override
    public BlockPos getCenterCoordinates() {
        return this.getTopCenterCoord();
    }

    @Override
    public void setCenterCoordinates(BlockPos coordinates) {
        if (!coordinates.equals((Object)this.centerPos) && this.isAssembled()) {
            this.centerPos = coordinates;
            this.provider.init(this.centerPos, this.limits);
            if (!this.world.field_72995_K) {
                this.assembleTickCount = this.getTickCount();
            }
        }
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        BlockPos centerTop = this.getTopCenterCoord();
        this.centerPos = centerTop.func_177981_b(3);
        this.createDefaultState();
        this.limits = this.createLimits();
        if (!this.climateContainer.getTargetedState().isPresent()) {
            IClimateState defaultClimate = this.getDefaultClimate();
            this.climateContainer.setState(defaultClimate.copy());
            this.climateContainer.setTargetedState(defaultClimate);
        }
        this.provider.init(this.centerPos, this.limits);
        this.assembleTickCount = this.getTickCount();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        this.energyManager.writeToNBT(data);
        data.func_74782_a(CAMOUFLAGE_NBT_KEY, (NBTBase)this.camouflage.serializeNBT());
        data.func_74782_a(CONTAINER_NBT_KEY, (NBTBase)this.climateContainer.writeToNBT(new NBTTagCompound()));
        data.func_74782_a(CENTER_POSITION_NBT_KEY, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.centerPos));
        for (IGreenhouseLogic logic : this.logics) {
            data.func_74782_a(logic.getUID(), (NBTBase)logic.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        NBTTagCompound nbtTag;
        super.readFromNBT(data);
        this.energyManager.readFromNBT(data);
        if (data.func_74764_b(CAMOUFLAGE_NBT_KEY)) {
            nbtTag = data.func_74775_l(CAMOUFLAGE_NBT_KEY);
            this.camouflage = new ItemStack(nbtTag);
        }
        if (data.func_74764_b(CONTAINER_NBT_KEY)) {
            nbtTag = data.func_74775_l(CONTAINER_NBT_KEY);
            this.climateContainer.readFromNBT(nbtTag);
        }
        if (data.func_74764_b(CENTER_POSITION_NBT_KEY)) {
            this.centerPos = NBTUtil.func_186861_c((NBTTagCompound)data.func_74775_l(CENTER_POSITION_NBT_KEY));
        }
        for (IGreenhouseLogic logic : this.logics) {
            logic.readFromNBT(data.func_74775_l(logic.getUID()));
        }
    }

    private void createDefaultState() {
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        double biomes = 0.0;
        double temperature = 0.0;
        double humidity = 0.0;
        for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
            for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                Biome biome = this.world.func_180494_b(new BlockPos(x, 0, z));
                temperature += (double)biome.func_185353_n();
                humidity += (double)biome.func_76727_i();
                biomes += 1.0;
            }
        }
        this.defaultState = ClimateStates.of((float)(temperature / biomes), (float)(humidity / biomes));
    }

    @Override
    public void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        int maxLevel = this.getMaximumCoord().func_177956_o() - this.getMinimumCoord().func_177956_o();
        if (level == maxLevel && !(part instanceof TileGreenhousePlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.needPlainOnTop"));
        }
        IGreenhouseBlock logicBlock = GreenhouseBlockManager.getInstance().getBlock(this.world, part.getCoordinates());
        if (logicBlock != null && logicBlock.getProvider() != this.getProvider()) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.needSpace"));
        }
    }

    @Override
    public void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileGreenhousePlain)) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.needPlainInterior"));
        }
        IGreenhouseBlock logicBlock = GreenhouseBlockManager.getInstance().getBlock(this.world, ((TileGreenhousePlain)part).func_174877_v());
        if (logicBlock != null && logicBlock.getProvider() != this.getProvider()) {
            throw new MultiblockValidationException(Translator.translateToLocal("for.multiblock.greenhouse.error.needSpace"));
        }
    }

    @Override
    public void onCheckPosition(BlockPos pos) {
    }

    private IGreenhouseLimits createLimits() {
        BlockPos centerTop = this.getTopCenterCoord();
        this.centerPos = centerTop.func_177981_b(3);
        BlockPos max = this.getMaximumCoord();
        BlockPos min = this.getMinimumCoord();
        int sizeNorthSouth = Math.abs(max.func_177952_p() - min.func_177952_p()) + 1;
        int sizeEastWest = Math.abs(max.func_177958_n() - min.func_177958_n()) + 1;
        int height = (Math.abs(max.func_177956_o() - min.func_177956_o()) + 2) * Config.greenhouseSize;
        int lengthEastWest = sizeEastWest * Config.greenhouseSize;
        int lengthNorthSouth = sizeNorthSouth * Config.greenhouseSize;
        return new GreenhouseLimits(new Position2D(lengthEastWest, lengthNorthSouth), new Position2D(-lengthEastWest, -lengthNorthSouth), height, 6);
    }
}

