/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.core.climate.ClimateStates;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.gui.ContainerGreenhouse;
import forestry.greenhouse.gui.GreenhouseEnergyLedger;
import forestry.greenhouse.gui.widgets.WidgetCamouflageTab;
import forestry.greenhouse.gui.widgets.WidgetClimateBar;
import forestry.greenhouse.gui.widgets.WidgetClimatePanel;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.network.packets.PacketSelectClimateTargeted;
import forestry.greenhouse.tiles.TileGreenhouse;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class GuiGreenhouse
extends GuiForestryTitled<ContainerGreenhouse> {
    private static final int GUI_HEIGHT = 119;
    private final IGreenhouseControllerInternal controller;
    private final TileGreenhouse tile;
    public WidgetClimatePanel temperaturePanel;
    public WidgetClimatePanel humidityPanel;
    public IClimateContainer container;

    public GuiGreenhouse(EntityPlayer player, TileGreenhouse tile) {
        super("textures/gui/greenhouse.png", new ContainerGreenhouse(player.field_71071_by, tile), tile);
        this.controller = ((MultiblockLogicGreenhouse)tile.getMultiblockLogic()).getController();
        this.container = this.controller.getClimateContainer();
        this.tile = tile;
        this.field_146999_f = 196;
        this.field_147000_g = 202;
        this.widgetManager.add(new WidgetCamouflageTab(this.widgetManager, this.field_146999_f / 4 - 34, -25, this.controller, tile));
        if (this.container.getTargetedState().isPresent()) {
            this.widgetManager.add(new WidgetClimateBar(this.widgetManager, this.field_146999_f / 3 + 30, -23));
        }
        this.temperaturePanel = new WidgetClimatePanel(this.widgetManager, this, 9, 18, ClimateType.TEMPERATURE);
        this.widgetManager.add(this.temperaturePanel);
        this.humidityPanel = new WidgetClimatePanel(this.widgetManager, this, 102, 18, ClimateType.HUMIDITY);
        this.widgetManager.add(this.humidityPanel);
    }

    public void sendNetworkUpdate() {
        IClimateState climateState = this.container.getTargetedState();
        if (climateState.isPresent()) {
            BlockPos pos = this.controller.getCoordinates();
            float temp = this.temperaturePanel.parseValue();
            float hum = this.humidityPanel.parseValue();
            this.setClimate(this.container, temp, hum);
            NetworkUtil.sendToServer(new PacketSelectClimateTargeted(pos, this.container.getTargetedState()));
        }
    }

    public void setClimate(IClimateContainer container, float temp, float hum) {
        this.temperaturePanel.setValue(temp);
        this.humidityPanel.setValue(hum);
        container.setTargetedState(ClimateStates.of(temp, hum));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.temperaturePanel.keyTyped(typedChar, keyCode) && !this.humidityPanel.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.controller);
        this.ledgerManager.add(new GreenhouseEnergyLedger(this.ledgerManager, this.controller));
        this.addClimateLedger(this.controller);
        this.addHintLedger("greenhouse");
        this.addOwnerLedger(this.tile);
    }
}

