/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.greenhouse.blocks.BlockClimatiserType;
import forestry.greenhouse.blocks.State;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum BlockClimatiserSprite {
    HYGRO("hygroregulator"),
    HEATER_OFF("heater.off"),
    HEATER_ON("heater.on"),
    FAN_OFF("fan.off"),
    FAN_ON("fan.on"),
    HUMIDIFIER_OFF("humidifier.off"),
    HUMIDIFIER_ON("humidifier.on"),
    DEHUMIDIFIER_OFF("dehumidifier.off"),
    DEHUMIDIFIER_ON("dehumidifier.on");

    public static final BlockClimatiserSprite[] VALUES;
    private static EnumMap<BlockClimatiserSprite, TextureAtlasSprite> sprites;
    private static TextureAtlasSprite missingImage;
    private final String spriteName;

    private BlockClimatiserSprite(String spriteName) {
        this.spriteName = spriteName;
    }

    public static void registerSprites() {
        sprites = new EnumMap(BlockClimatiserSprite.class);
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (BlockClimatiserSprite sprite : VALUES) {
            ResourceLocation location = new ResourceLocation("forestry", "blocks/greenhouse/" + sprite.spriteName);
            TextureAtlasSprite textureAtlasSprite = map.func_174942_a(location);
            sprites.put(sprite, textureAtlasSprite);
        }
        missingImage = map.field_94249_f;
    }

    public static TextureAtlasSprite getSprite(BlockClimatiserType type, @Nullable EnumFacing facing, @Nullable IBlockState state) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        switch (type) {
            case HYGRO: {
                return sprites.get((Object)HYGRO);
            }
            case HEATER: {
                if (state == null || state.func_177229_b(State.PROPERTY) == State.OFF) {
                    return sprites.get((Object)HEATER_OFF);
                }
                return sprites.get((Object)HEATER_ON);
            }
            case FAN: {
                if (state == null || state.func_177229_b(State.PROPERTY) == State.OFF) {
                    return sprites.get((Object)FAN_OFF);
                }
                return sprites.get((Object)FAN_ON);
            }
            case HUMIDIFIER: {
                if (state == null || state.func_177229_b(State.PROPERTY) == State.OFF) {
                    return sprites.get((Object)HUMIDIFIER_OFF);
                }
                return sprites.get((Object)HUMIDIFIER_ON);
            }
            case DEHUMIDIFIER: {
                if (state == null || state.func_177229_b(State.PROPERTY) == State.OFF) {
                    return sprites.get((Object)DEHUMIDIFIER_OFF);
                }
                return sprites.get((Object)DEHUMIDIFIER_ON);
            }
        }
        return missingImage;
    }

    static {
        VALUES = BlockClimatiserSprite.values();
    }
}

