/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import com.google.common.base.Preconditions;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.climate.ClimateType;
import forestry.api.core.CamouflageManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.modules.ForestryModule;
import forestry.core.CreativeTabForestry;
import forestry.core.ModuleCore;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.Circuits;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.greenhouse.GreenhouseHelper;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.api.greenhouse.IGreenhouseHelper;
import forestry.greenhouse.blocks.BlockClimatiserType;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.blocks.BlockRegistryGreenhouse;
import forestry.greenhouse.camouflage.CamouflageAccess;
import forestry.greenhouse.camouflage.CamouflageHandlerBlock;
import forestry.greenhouse.circuits.CircuitClimateSource;
import forestry.greenhouse.climate.GreenhouseClimateManager;
import forestry.greenhouse.climate.modifiers.AltitudeModifier;
import forestry.greenhouse.climate.modifiers.ClimateSourceModifier;
import forestry.greenhouse.climate.modifiers.TimeModifier;
import forestry.greenhouse.climate.modifiers.WeatherModifier;
import forestry.greenhouse.items.ItemRegistryGreenhouse;
import forestry.greenhouse.multiblock.GreenhouseController;
import forestry.greenhouse.multiblock.blocks.ChunkEvents;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import forestry.greenhouse.network.PacketRegistryGreenhouse;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import forestry.greenhouse.tiles.TileDehumidifier;
import forestry.greenhouse.tiles.TileFan;
import forestry.greenhouse.tiles.TileGreenhouseControl;
import forestry.greenhouse.tiles.TileGreenhouseGearbox;
import forestry.greenhouse.tiles.TileGreenhousePlain;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import forestry.greenhouse.tiles.TileHeater;
import forestry.greenhouse.tiles.TileHumidifier;
import forestry.greenhouse.tiles.TileHygroregulator;
import forestry.modules.BlankForestryModule;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryModule(containerID="forestry", moduleID="greenhouse", name="Greenhouse", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.greenhouse.description")
public class ModuleGreenhouse
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.greenhouse.proxy.ProxyGreenhouseClient", serverSide="forestry.greenhouse.proxy.ProxyGreenhouse")
    public static ProxyGreenhouse proxy;
    @Nullable
    private static BlockRegistryGreenhouse blocks;
    @Nullable
    private static ItemRegistryGreenhouse items;

    public static BlockRegistryGreenhouse getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    public static ItemRegistryGreenhouse getItems() {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0);
        return items;
    }

    public static CreativeTabs getGreenhouseTab() {
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            return Tabs.tabAgriculture;
        }
        return CreativeTabForestry.tabForestry;
    }

    @Override
    public void setupAPI() {
        GreenhouseManager.helper = new GreenhouseHelper();
        GreenhouseManager.blockManager = GreenhouseBlockManager.getInstance();
        GreenhouseManager.climateManager = GreenhouseClimateManager.getInstance();
        CamouflageManager.camouflageAccess = new CamouflageAccess();
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryGreenhouse();
        items = new ItemRegistryGreenhouse();
    }

    @Override
    public void preInit() {
        proxy.preInti();
        MinecraftForge.EVENT_BUS.register((Object)new ChunkEvents());
        CamouflageManager.camouflageAccess.registerItemHandler(new CamouflageHandlerBlock());
        proxy.initializeModels();
        CircuitLayout layoutManaged = new CircuitLayout("greenhouse.climatiser", CircuitSocketType.GREENHOUSE_CLIMATISER);
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
    }

    @Override
    public void doInit() {
        IGreenhouseHelper helper = GreenhouseManager.helper;
        GameRegistry.registerTileEntity(TileGreenhousePlain.class, (String)"forestry.GreenhousePlain");
        GameRegistry.registerTileEntity(TileHygroregulator.class, (String)"forestry.ClimateSourceHygroregulator");
        GameRegistry.registerTileEntity(TileGreenhouseGearbox.class, (String)"forestry.GreenhouseGearbox");
        GameRegistry.registerTileEntity(TileGreenhouseControl.class, (String)"forestry.GreenhouseController");
        GameRegistry.registerTileEntity(TileGreenhouseWindow.class, (String)"forestry.ClimateSourceWindow");
        GameRegistry.registerTileEntity(TileFan.class, (String)"forestry.GreenhouseFan");
        GameRegistry.registerTileEntity(TileHeater.class, (String)"forestry.GreenhouseHeater");
        GameRegistry.registerTileEntity(TileDehumidifier.class, (String)"forestry.GreenhouseDryer");
        GameRegistry.registerTileEntity(TileHumidifier.class, (String)"forestry.GreenhouseSprinkler");
        helper.registerWindowGlass("glass", new ItemStack(Blocks.field_150359_w), "blocks/glass");
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            helper.registerWindowGlass("glass" + dye.func_176610_l(), new ItemStack((Block)Blocks.field_150399_cn, 1, dye.func_176765_a()), "blocks/glass_" + dye.func_176610_l());
        }
        GreenhouseClimateManager climateSourceManager = GreenhouseClimateManager.getInstance();
        climateSourceManager.registerModifier(new WeatherModifier());
        climateSourceManager.registerModifier(new TimeModifier());
        climateSourceManager.registerModifier(new AltitudeModifier());
        climateSourceManager.registerModifier(new ClimateSourceModifier());
        Circuits.climatiserTemperature1 = new CircuitClimateSource("climatiser.temperature.1", ClimateType.TEMPERATURE, 0.125f, 0.125f, 0.25f);
        Circuits.climatiserTemperature2 = new CircuitClimateSource("climatiser.temperature.2", ClimateType.TEMPERATURE, 0.25f, 0.25f, 0.5f);
        Circuits.climatiserHumidity1 = new CircuitClimateSource("climatiser.humidity.1", ClimateType.HUMIDITY, 0.125f, 0.125f, 0.25f);
        Circuits.climatiserHumidity2 = new CircuitClimateSource("climatiser.humidity.2", ClimateType.HUMIDITY, 0.25f, 0.25f, 0.5f);
        proxy.inti();
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryGreenhouse blocks = ModuleGreenhouse.getBlocks();
        ItemRegistryGreenhouse items = ModuleGreenhouse.getItems();
        RecipeUtil.addRecipe("camouflage_spray_can", items.camouflageSprayCan, "TTT", "TCT", "TCT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), coreItems.craftingMaterial.getCamouflagedPaneling());
        ItemStack greenhousePlainBlock = new ItemStack((Block)blocks.greenhouseBlock, 2, BlockGreenhouseType.PLAIN.ordinal());
        RecipeUtil.addRecipe("greenhouse_plain", greenhousePlainBlock.func_77946_l(), "#X#", "SIS", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "slabWood", Character.valueOf('X'), GreenhouseController.createDefaultCamouflageBlock(), Character.valueOf('#'), coreItems.craftingMaterial.getCamouflagedPaneling());
        greenhousePlainBlock.func_190920_e(1);
        RecipeUtil.addRecipe("greenhouse_control", new ItemStack((Block)blocks.greenhouseBlock, 1, BlockGreenhouseType.CONTROL.ordinal()), " X ", "#T#", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "dustRedstone", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1));
        RecipeUtil.addRecipe("greenhouse_gearbox", new ItemStack((Block)blocks.greenhouseBlock, 1, BlockGreenhouseType.GEARBOX.ordinal()), " X ", "###", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "gearTin");
        RecipeUtil.addRecipe("greenhouse_hygro", new ItemStack((Block)blocks.climatiserBlock, 1, BlockClimatiserType.HYGRO.ordinal()), "GIG", "GXG", "GIG", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass");
        RecipeUtil.addRecipe("greenhouse_heater", new ItemStack((Block)blocks.climatiserBlock, 1, BlockClimatiserType.HEATER.ordinal()), "T#T", "#X#", "T#T", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.GOLD, 1));
        RecipeUtil.addRecipe("greenhouse_fan", new ItemStack((Block)blocks.climatiserBlock, 1, BlockClimatiserType.FAN.ordinal()), "T#T", "#X#", "T#T", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "ingotIron", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.TIN, 1));
        RecipeUtil.addRecipe("greenhouse_dehumidifier", new ItemStack((Block)blocks.climatiserBlock, 1, BlockClimatiserType.DEHUMIDIFIER.ordinal()), "T#T", "#X#", "T#T", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.BLAZE, 1));
        RecipeUtil.addRecipe("greenhouse_humidifier", new ItemStack((Block)blocks.climatiserBlock, 1, BlockClimatiserType.HUMIDIFIER.ordinal()), "T#T", "#X#", "T#T", Character.valueOf('X'), greenhousePlainBlock.func_77946_l(), Character.valueOf('#'), "ingotTin", Character.valueOf('T'), coreItems.tubes.get(EnumElectronTube.LAPIS, 1));
        for (String glassName : GreenhouseManager.helper.getWindowGlasses()) {
            ItemStack glassItem = GreenhouseManager.helper.getGlassItem(glassName);
            ItemStack window = blocks.window.getItem(glassName);
            ItemStack roodWindow = blocks.roofWindow.getItem(glassName);
            RecipeUtil.addRecipe("greenhouse_window_" + glassName, roodWindow, true, "SGS", "GGG", "GGG", Character.valueOf('G'), glassItem, Character.valueOf('S'), "stickWood");
            RecipeUtil.addRecipe("greenhouse_window_roof_" + glassName, window, true, "SGG", "GGG", "SGG", Character.valueOf('G'), glassItem, Character.valueOf('S'), "stickWood");
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.greenhouse.climatiser");
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.GOLD, 1), Circuits.climatiserTemperature1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.BLAZE, 1), Circuits.climatiserTemperature2);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.LAPIS, 1), Circuits.climatiserHumidity1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.OBSIDIAN, 1), Circuits.climatiserHumidity2);
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryGreenhouse();
    }
}

