/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableStacked
implements IFarmable {
    protected final ItemStack germling;
    protected final Block cropBlock;
    protected final int matureHeight;

    public FarmableStacked(ItemStack germling, Block cropBlock, int matureHeight) {
        this.germling = germling;
        this.cropBlock = cropBlock;
        this.matureHeight = matureHeight;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() == this.cropBlock;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        BlockPos cropPos = pos.func_177982_a(0, this.matureHeight - 1, 0);
        blockState = world.func_180495_p(cropPos);
        if (blockState.func_177230_c() != this.cropBlock) {
            return null;
        }
        return new CropDestroy(world, blockState, cropPos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return BlockUtil.setBlockWithPlaceSound(world, pos, this.cropBlock.func_176223_P());
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

