/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.TileBase;
import forestry.core.utils.GeneticsUtil;
import forestry.database.gui.ContainerDatabase;
import forestry.database.gui.GuiDatabase;
import forestry.database.inventory.InventoryDatabase;
import forestry.database.inventory.InventoryDatabaseAnalyzer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDatabase
extends TileBase
implements IOwnedTile {
    @SideOnly(value=Side.CLIENT)
    public int selectedSlot;
    private final OwnerHandler ownerHandler = new OwnerHandler();
    public InventoryDatabaseAnalyzer analyzerInventory;

    public TileDatabase() {
        this.setInternalInventory(new InventoryDatabase(this));
        this.analyzerInventory = new InventoryDatabaseAnalyzer(this);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.selectedSlot = -1;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiDatabase(this, player);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerDatabase(this, player.field_71071_by);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.ownerHandler.writeToNBT(nbttagcompound);
        this.analyzerInventory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ownerHandler.readFromNBT(nbttagcompound);
        this.analyzerInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.ownerHandler.writeToNBT(updateTag);
        return updateTag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.ownerHandler.readFromNBT(tag);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    public ItemStack analyzeSpecimen(int selectedDatabaseSlot) {
        ISpeciesRoot speciesRoot;
        if (selectedDatabaseSlot < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack specimen = this.func_70301_a(selectedDatabaseSlot);
        if (specimen.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            this.func_70299_a(selectedDatabaseSlot, convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) == null) {
            return specimen;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (individual != null && !individual.isAnalyzed()) {
            boolean requiresEnergy = ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "apiculture"));
            if (requiresEnergy) {
                if (!InventoryDatabaseAnalyzer.isAlyzingFuel(this.analyzerInventory.func_70301_a(0))) {
                    return specimen;
                }
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(this.field_145850_b, this.ownerHandler.getOwner());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                individual.writeToNBT(nbttagcompound);
                specimen.func_77982_d(nbttagcompound);
                if (requiresEnergy) {
                    this.analyzerInventory.func_70298_a(0, 1);
                }
            }
            this.func_70299_a(selectedDatabaseSlot, specimen);
        }
        return specimen;
    }
}

