/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.database.gui.ContainerDatabase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PacketInsertItem
extends ForestryPacket
implements IForestryPacketServer {
    private final boolean single;

    public PacketInsertItem(boolean single) {
        this.single = single;
    }

    @Override
    protected void writeData(PacketBufferForestry data) throws IOException {
        data.writeBoolean(this.single);
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.INSERT_ITEM;
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) throws IOException {
            boolean single = data.readBoolean();
            Container container = player.field_71070_bA;
            if (!(container instanceof ContainerDatabase)) {
                return;
            }
            IItemHandler itemHandler = ((ContainerDatabase)container).getItemHandler();
            if (itemHandler == null) {
                return;
            }
            ItemStack playerStack = player.field_71071_by.func_70445_o();
            ItemStack itemStack = playerStack.func_77946_l();
            if (single) {
                itemStack.func_190920_e(1);
            }
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack, (boolean)false);
            if (single && remaining.func_190926_b()) {
                playerStack.func_190918_g(1);
                if (playerStack.func_190926_b()) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            } else {
                player.field_71071_by.func_70437_b(remaining);
            }
            if (container instanceof ContainerDatabase) {
                ((ContainerDatabase)container).sendContainerToListeners();
            }
        }
    }
}

