/*
 * Decompiled with CFR 0.152.
 */
package forestry.database;

import com.google.common.base.Preconditions;
import forestry.api.modules.ForestryModule;
import forestry.apiculture.ModuleApiculture;
import forestry.arboriculture.ModuleArboriculture;
import forestry.core.ModuleCore;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.database.blocks.BlockRegistryDatabase;
import forestry.database.network.PacketRegistryDatabase;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleManager;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ForestryModule(containerID="forestry", moduleID="database", name="Database", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.database.description")
public class ModuleDatabase
extends BlankForestryModule {
    @Nullable
    private static BlockRegistryDatabase blocks;

    public static BlockRegistryDatabase getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryDatabase();
    }

    @Override
    public void doInit() {
        BlockRegistryDatabase blocks = ModuleDatabase.getBlocks();
        blocks.database.init();
    }

    @Override
    public void registerRecipes() {
        LinkedList<ItemStack> possibleChests = new LinkedList<ItemStack>();
        LinkedList<Object> possibleSpecial = new LinkedList<Object>();
        if (ModuleManager.getInstance().isModuleEnabled("forestry", "apiculture")) {
            possibleChests.add(new ItemStack(ModuleApiculture.getBlocks().beeChest));
            possibleSpecial.add(new ItemStack((Item)ModuleApiculture.getItems().royalJelly));
        }
        if (ModuleManager.getInstance().isModuleEnabled("forestry", "arboriculture")) {
            possibleChests.add(new ItemStack((Block)ModuleArboriculture.getBlocks().treeChest));
            possibleSpecial.add(ItemFruit.EnumFruit.PLUM.getStack());
        }
        if (ModuleManager.getInstance().isModuleEnabled("forestry", "lepidopterology")) {
            possibleChests.add(new ItemStack((Block)ModuleLepidopterology.getBlocks().butterflyChest));
        }
        if (possibleChests.size() == 1) {
            this.addRecipe(possibleSpecial, "chestWood", possibleChests.get(0));
        }
        if (possibleSpecial.isEmpty()) {
            possibleSpecial.add("chestWood");
        }
        if (possibleChests.isEmpty()) {
            this.addRecipe(possibleSpecial, "chestWood", "chestWood");
        } else {
            for (int firstChest = 0; firstChest < possibleChests.size(); ++firstChest) {
                for (int secondChest = 0; secondChest < possibleChests.size(); ++secondChest) {
                    if (secondChest == firstChest) continue;
                    this.addRecipe(possibleSpecial, possibleChests.get(firstChest), possibleChests.get(secondChest));
                }
            }
        }
    }

    private void addRecipe(List<Object> possibleSpecial, Object firstChest, Object secondChest) {
        for (Object special : possibleSpecial) {
            ItemRegistryCore coreItems = ModuleCore.getItems();
            RecipeUtil.addRecipe("database_" + this.getIngredientName(firstChest) + "_" + this.getIngredientName(secondChest) + "_" + this.getIngredientName(special), ModuleDatabase.getBlocks().database, "I#I", "FYS", "WCW", Character.valueOf('#'), coreItems.portableAlyzer, Character.valueOf('I'), "ingotBronze", Character.valueOf('W'), "plankWood", Character.valueOf('C'), special, Character.valueOf('Y'), coreItems.sturdyCasing, Character.valueOf('F'), firstChest, Character.valueOf('S'), secondChest);
        }
    }

    private String getIngredientName(Object o) {
        return o instanceof ItemStack ? ((ItemStack)o).func_77973_b().getRegistryName().func_110623_a() : o.toString();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryDatabase();
    }
}

