/*
 * Decompiled with CFR 0.152.
 */
package forestry.database;

import forestry.database.DatabaseHelper;
import forestry.database.DatabaseItem;
import forestry.database.gui.GuiDatabase;
import forestry.database.tiles.TileDatabase;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class DatabaseManager {
    private final ArrayList<DatabaseItem> sorted = new ArrayList();
    private final TileDatabase tile;
    public final GuiDatabase gui;
    private boolean markedForSorting;
    private int selectedSlot;
    @Nullable
    private DatabaseItem selected;

    public DatabaseManager(TileDatabase tile, GuiDatabase gui) {
        this.tile = tile;
        this.gui = gui;
    }

    public boolean canAdd() {
        return this.selectedSlot + 1 < this.getSize();
    }

    public boolean canSubtract() {
        int selectedSlot = this.selectedSlot - 1;
        return selectedSlot < this.getSize() && selectedSlot >= 0;
    }

    public int getSize() {
        return this.sorted.size() - 1;
    }

    public int getRealSize() {
        return this.sorted.size();
    }

    public void setSelectedSlot(int selectedSlot) {
        int oldSelected = this.selectedSlot;
        this.selectedSlot = selectedSlot;
        this.selected = selectedSlot < 0 ? null : this.sorted.get(selectedSlot);
        this.gui.onUpdateSelectedSlot(oldSelected != selectedSlot && this.selected != null);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Nullable
    public DatabaseItem getSelected() {
        return this.selected;
    }

    public ItemStack getSelectedItemStack() {
        if (this.selected == null) {
            return ItemStack.field_190927_a;
        }
        return this.selected.itemStack;
    }

    public void updateSelected() {
        int index = this.sorted.indexOf(this.selected);
        if (index >= 0) {
            this.setSelectedSlot(this.sorted.indexOf(this.selected));
            return;
        }
        if (this.sorted.isEmpty()) {
            this.setSelectedSlot(-1);
            return;
        }
        int size = this.getSize();
        if (size <= 0) {
            this.setSelectedSlot(-1);
            return;
        }
        if (size > this.selectedSlot && index != -1) {
            return;
        }
        this.setSelectedSlot(0);
    }

    public void markForSorting() {
        this.markedForSorting = true;
    }

    public void update(String searchText) {
        if (this.markedForSorting) {
            this.markedForSorting = false;
            this.sortItems(searchText);
        }
    }

    public void sortItems(String searchText) {
        this.sorted.clear();
        ArrayList<DatabaseItem> items = new ArrayList<DatabaseItem>();
        boolean firstEmpty = false;
        for (int invIndex = 0; invIndex < this.tile.func_70302_i_(); ++invIndex) {
            ItemStack stack = this.tile.func_70301_a(invIndex).func_77946_l();
            if (!stack.func_190926_b()) {
                items.add(new DatabaseItem(stack, invIndex));
                continue;
            }
            if (firstEmpty) continue;
            firstEmpty = true;
            items.add(new DatabaseItem(stack, invIndex));
        }
        DatabaseHelper.update(searchText, items, this.sorted);
        this.updateSelected();
        this.gui.onSortItems(this.sorted);
    }

    @Nullable
    public DatabaseItem getItem(int index) {
        if (this.sorted.isEmpty() || this.sorted.size() <= index || index < 0) {
            return null;
        }
        return this.sorted.get(index);
    }

    public ArrayList<DatabaseItem> getSorted() {
        return this.sorted;
    }
}

