/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.energy.EnergyTransferMode;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TilePowered
extends TileBase
implements IRenderableTile,
ISpeedUpgradable,
IStreamableGui {
    private static final int WORK_TICK_INTERVAL = 5;
    private final EnergyManager energyManager;
    private int workCounter;
    private int ticksPerWorkCycle;
    private int energyPerWorkCycle;
    protected float speedMultiplier = 1.0f;
    protected float powerMultiplier = 1.0f;
    private int noPowerTime = 0;

    protected TilePowered(int maxTransfer, int capacity) {
        this.energyManager = new EnergyManager(maxTransfer, capacity);
        this.energyManager.setExternalMode(EnergyTransferMode.RECEIVE);
        this.ticksPerWorkCycle = 4;
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    public int getWorkCounter() {
        return this.workCounter;
    }

    public void setTicksPerWorkCycle(int ticksPerWorkCycle) {
        this.ticksPerWorkCycle = ticksPerWorkCycle;
        this.workCounter = 0;
    }

    public int getTicksPerWorkCycle() {
        if (this.field_145850_b.field_72995_K) {
            return this.ticksPerWorkCycle;
        }
        return Math.round((float)this.ticksPerWorkCycle / this.speedMultiplier);
    }

    public void setEnergyPerWorkCycle(int energyPerWorkCycle) {
        this.energyPerWorkCycle = EnergyHelper.scaleForDifficulty(energyPerWorkCycle);
    }

    public int getEnergyPerWorkCycle() {
        return Math.round((float)this.energyPerWorkCycle * this.powerMultiplier);
    }

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public abstract boolean hasWork();

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(5)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean disabled = this.isRedstoneActivated();
        errorLogic.setCondition(disabled, EnumErrorCode.DISABLED_BY_REDSTONE);
        if (disabled) {
            return;
        }
        if (!this.hasWork()) {
            return;
        }
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (this.workCounter < ticksPerWorkCycle) {
            int energyPerWorkCycle = this.getEnergyPerWorkCycle();
            boolean consumedEnergy = EnergyHelper.consumeEnergyToDoWork(this.energyManager, ticksPerWorkCycle, energyPerWorkCycle);
            if (consumedEnergy) {
                errorLogic.setCondition(false, EnumErrorCode.NO_POWER);
                ++this.workCounter;
                this.noPowerTime = 0;
            } else {
                ++this.noPowerTime;
                if (this.noPowerTime > 4) {
                    errorLogic.setCondition(true, EnumErrorCode.NO_POWER);
                }
            }
        }
        if (this.workCounter >= ticksPerWorkCycle && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    protected abstract boolean workCycle();

    public int getProgressScaled(int i) {
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (ticksPerWorkCycle == 0) {
            return 0;
        }
        return this.workCounter * i / ticksPerWorkCycle;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.energyManager.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.energyManager.writeData(data);
        data.func_150787_b(this.workCounter);
        data.func_150787_b(this.getTicksPerWorkCycle());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.energyManager.readData(data);
        this.workCounter = data.func_150792_a();
        this.ticksPerWorkCycle = data.func_150792_a();
    }

    @Override
    public void applySpeedUpgrade(double speedChange, double powerChange) {
        this.speedMultiplier = (float)((double)this.speedMultiplier + speedChange);
        this.powerMultiplier = (float)((double)this.powerMultiplier + powerChange);
        this.workCounter = 0;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.energyManager.hasCapability(capability) || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T energyCapability = this.energyManager.getCapability(capability);
        if (energyCapability != null) {
            return energyCapability;
        }
        return super.getCapability(capability, facing);
    }
}

