/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.Drawable;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.gui.widgets.WidgetSlider;
import java.util.Optional;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class WidgetScrollBar
extends Widget {
    private Optional<Drawable> background;
    private WidgetSlider slider;
    private boolean visible;
    private int minValue;
    private int maxValue;
    private int step;
    private int currentValue;
    private IScrollable listener;
    private boolean isScrolling;
    private boolean wasClicked;
    private int initialMouseClickY;

    public WidgetScrollBar(WidgetManager manager, int xPos, int yPos, int width, int height, Drawable sliderTexture) {
        super(manager, xPos, yPos);
        this.background = Optional.empty();
        this.width = width;
        this.height = height;
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.slider = new WidgetSlider(manager, xPos, yPos, sliderTexture);
    }

    public WidgetScrollBar(WidgetManager manager, int xPos, int yPos, Drawable backgroundTexture, boolean hasBorder, Drawable sliderTexture) {
        super(manager, xPos, yPos);
        int offset = hasBorder ? 1 : 0;
        this.background = Optional.of(backgroundTexture);
        this.width = backgroundTexture.width;
        this.height = backgroundTexture.height;
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.slider = new WidgetSlider(manager, xPos + offset, yPos + offset, sliderTexture);
    }

    public void setParameters(IScrollable listener, int minValue, int maxValue, int step) {
        this.listener = listener;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.setValue(this.currentValue);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)this.currentValue, (int)this.minValue, (int)this.maxValue);
    }

    public int setValue(int value) {
        this.currentValue = MathHelper.func_76125_a((int)value, (int)this.minValue, (int)this.maxValue);
        if (this.listener != null) {
            this.listener.onScroll(this.currentValue);
        }
        int offset = value >= this.maxValue ? this.height - this.slider.height : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.height - this.slider.height)));
        this.slider.setOffset(0, offset);
        return this.currentValue;
    }

    @Override
    public void draw(int startX, int startY) {
        if (!this.isVisible()) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.background.isPresent()) {
            this.background.get().draw(startX + this.xPos, startY + this.yPos);
        }
        this.slider.draw(startX, startY);
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (this.listener == null || this.listener.isFocused(mouseX, mouseY)) {
            int wheel = Mouse.getDWheel();
            if (wheel > 0) {
                this.setValue(this.currentValue - this.step);
                return;
            }
            if (wheel < 0) {
                this.setValue(this.currentValue + this.step);
                return;
            }
        }
        int y = mouseY - this.yPos;
        if (!mouseDown && this.wasClicked) {
            this.wasClicked = false;
        }
        if (!mouseDown && this.isScrolling) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            float range = this.maxValue - this.minValue;
            float value = (float)(y - this.initialMouseClickY) / (float)(this.height - this.slider.height);
            if ((value *= range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
        } else if (this.slider.isMouseOver(mouseX, mouseY)) {
            if (mouseDown) {
                this.isScrolling = true;
                this.initialMouseClickY = y - this.slider.getYOffset();
            }
        } else if (mouseDown && !this.wasClicked && this.isMouseOver(mouseX, mouseY)) {
            float range = this.maxValue - this.minValue;
            float value = (float)(y - this.slider.height / 2) / (float)(this.height - this.slider.height);
            if ((value *= range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
            this.wasClicked = true;
        }
    }
}

