/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementLayout;
import forestry.core.gui.elements.GuiElementLayout;

public class GuiElementVertical
extends GuiElementLayout {
    public GuiElementVertical(int xPos, int yPos, int width) {
        super(xPos, yPos, width, 0);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public IGuiElementLayout addElement(IGuiElement element) {
        this.elements.add(element);
        element.setYOffset(this.height);
        this.height += element.getHeight() + this.distance;
        return this;
    }

    @Override
    public IGuiElementLayout removeElement(IGuiElement element) {
        this.elements.remove(element);
        this.height -= element.getHeight() + this.distance;
        element.setYOffset(0);
        return this;
    }

    @Override
    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        int width = 0;
        for (IGuiElement element : this.elements) {
            int elementWidth = element.getWidth();
            if (elementWidth <= width) continue;
            width = elementWidth;
        }
        return width;
    }
}

