/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementHelper;
import forestry.api.core.IGuiElementLayout;
import forestry.api.core.IGuiElementLayoutHelper;
import forestry.core.gui.elements.GuiElementVertical;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuiElementLayoutHelper
implements IGuiElementLayoutHelper {
    private final List<IGuiElementLayout> layouts = new ArrayList<IGuiElementLayout>();
    private final IGuiElementLayoutHelper.LayoutFactory layoutFactory;
    private final int width;
    private final int height;
    private final IGuiElementHelper parent;
    private int xOffset;
    private int yOffset;
    private IGuiElementLayout currentLayout;
    private boolean horizontal;

    public GuiElementLayoutHelper(IGuiElementLayoutHelper.LayoutFactory layoutFactory, int width, int height, IGuiElementHelper parent) {
        this.layoutFactory = layoutFactory;
        this.width = width;
        this.height = height;
        this.parent = parent;
    }

    @Override
    public boolean add(IGuiElement element) {
        if (this.currentLayout == null) {
            this.currentLayout = this.layoutFactory.createLayout(0, 0);
            this.layouts.add(this.currentLayout);
            this.horizontal = this.currentLayout instanceof GuiElementVertical;
        }
        int groupWidth = this.currentLayout.getWidth();
        int groupHeight = this.currentLayout.getHeight();
        int eleWidth = element.getX() + element.getWidth();
        int eleHeight = element.getY() + element.getHeight();
        if (this.horizontal) {
            if (this.yOffset >= this.height) {
                if (this.width != 0 && this.xOffset > this.width) {
                    return false;
                }
                this.xOffset += this.currentLayout.getWidth();
                this.currentLayout = this.layoutFactory.createLayout(0, 0);
                this.layouts.add(this.currentLayout);
                groupHeight = this.currentLayout.getHeight();
            }
            this.yOffset = groupHeight += eleHeight;
        } else {
            if (this.xOffset >= this.width) {
                if (this.height != 0 && this.yOffset > this.height) {
                    return false;
                }
                this.yOffset += this.currentLayout.getHeight();
                this.currentLayout = this.layoutFactory.createLayout(0, 0);
                this.layouts.add(this.currentLayout);
                groupWidth = this.currentLayout.getWidth();
            }
            this.xOffset = groupWidth += eleWidth;
        }
        this.currentLayout.addElement(element);
        return true;
    }

    @Override
    public void finish() {
        for (IGuiElement iGuiElement : this.layouts) {
            this.parent.add(iGuiElement);
        }
        this.clear();
    }

    @Override
    public void clear() {
        this.layouts.clear();
        this.currentLayout = null;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    @Override
    public Collection<IGuiElementLayout> layouts() {
        return this.layouts;
    }
}

