/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.core.GuiElementAlignment;
import forestry.api.core.IGuiElement;
import forestry.api.core.IGuiElementFactory;
import forestry.api.core.IGuiElementHelper;
import forestry.api.core.IGuiElementLayout;
import forestry.api.core.IGuiElementLayoutHelper;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.GuiElementItemStack;
import forestry.core.gui.elements.GuiElementLayoutHelper;
import forestry.core.gui.elements.GuiElementText;
import forestry.core.render.ColourProperties;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuiElementHelper
implements IGuiElementHelper {
    private final IGuiElementLayout parent;
    private final int defaultColor;

    public GuiElementHelper(IGuiElementLayout parent) {
        this.parent = parent;
        this.defaultColor = ColourProperties.INSTANCE.get("gui.screen");
    }

    @Override
    public GuiElementLayoutHelper layoutHelper(IGuiElementLayoutHelper.LayoutFactory layoutFactory, int width, int height) {
        return new GuiElementLayoutHelper(layoutFactory, width, height, this);
    }

    public void add(IGuiElementLayoutHelper groupHelper) {
        groupHelper.layouts().forEach(element -> this.add((IGuiElement)element));
    }

    @Override
    public void add(IGuiElement element) {
        this.parent.addElement(element);
    }

    @Override
    public void addItem(int x, ItemStack itemStack) {
        this.parent.addElement(new GuiElementItemStack(x, 0, itemStack));
    }

    @Override
    public final void addAllele(String chromosomeName, IIndividual individual, IChromosomeType chromosome, boolean active) {
        this.addAllele(chromosomeName, allele -> allele.getAlleleName(), individual, chromosome, active);
    }

    @Override
    public final <A extends IAllele> void addAllele(String chromosomeName, Function<A, String> toString, IIndividual individual, IChromosomeType chromosome, boolean active) {
        IAllele allele = active ? individual.getGenome().getActiveAllele(chromosome) : individual.getGenome().getInactiveAllele(chromosome);
        this.addText(TextFormatting.UNDERLINE + chromosomeName, GuiElementAlignment.CENTER);
        this.addText(toString.apply(allele), GuiElementAlignment.CENTER, this.factory().getColorCoding(allele.isDominant()));
    }

    @Override
    public void addMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        IGuiElement element = this.factory().createMutation(x, y, width, height, mutation, species, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        IGuiElement element = this.factory().createMutationResultant(x, y, width, height, mutation, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addFertilityInfo(IAlleleInteger fertilityAllele, int x, int texOffset) {
        this.add(this.centerElement(this.factory().createFertilityInfo(fertilityAllele, x, texOffset)));
    }

    @Override
    public void addToleranceInfo(IAlleleTolerance toleranceAllele, IAlleleSpecies species, String text) {
        this.add(this.centerElement(this.factory().createToleranceInfo(toleranceAllele, species, text)));
    }

    @Override
    public void addText(String text) {
        this.addText(0, text, this.defaultColor);
    }

    @Override
    public void addText(String text, int color) {
        this.addText(0, text, color);
    }

    @Override
    public void addText(String text, GuiElementAlignment align) {
        this.addText(text, align, this.defaultColor);
    }

    @Override
    public void addText(String text, GuiElementAlignment align, int color) {
        this.addText(0, text, align, color);
    }

    public void addText(int x, String text, int color) {
        this.addText(x, text, GuiElementAlignment.LEFT, color);
    }

    public void addText(int x, String text, GuiElementAlignment align, int color) {
        this.addText(x, 12, text, align, color);
    }

    @Override
    public void addText(int x, int height, String text, GuiElementAlignment align, int color) {
        this.parent.addElement(new GuiElementText(x, 0, this.parent.getWidth(), height, text, align, color));
    }

    @Override
    public IGuiElement centerElement(IGuiElement element) {
        element.setXOffset((this.parent.getWidth() - element.getWidth()) / 2);
        return element;
    }

    @Override
    public IGuiElementLayout getParent() {
        return this.parent;
    }

    @Override
    public IGuiElementFactory factory() {
        return GuiElementFactory.INSTANCE;
    }
}

