/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.buttons;

import forestry.core.gui.buttons.IButtonTextureSet;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.render.ForestryResource;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBetterButton
extends GuiButton
implements IToolTipProvider {
    private static final ResourceLocation TEXTURE = new ForestryResource("textures/gui/buttons.png");
    protected IButtonTextureSet texture;
    @Nullable
    private ToolTip toolTip;
    private boolean useTexWidth = false;

    public GuiBetterButton(int id, int x, int y, IButtonTextureSet texture) {
        super(id, x, y, texture.getWidth(), texture.getHeight(), "");
        this.texture = texture;
        this.useTexWidth = true;
    }

    public GuiBetterButton setTexture(IButtonTextureSet texture) {
        this.texture = texture;
        this.field_146120_f = texture.getWidth();
        this.field_146121_g = texture.getHeight();
        return this;
    }

    public GuiBetterButton setUseTextureWidth() {
        this.useTexWidth = true;
        return this;
    }

    public GuiBetterButton setGuiWidth(int width) {
        this.field_146120_f = width;
        this.useTexWidth = false;
        return this;
    }

    public GuiBetterButton setLabel(String label) {
        this.field_146126_j = label;
        return this;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.field_146124_l) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.getWidth() && mouseY < this.field_146129_i + this.getHeight();
    }

    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        FontRenderer fontrenderer = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        boolean mouseOver = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.func_146114_a(mouseOver);
        if (this.useTexWidth) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, xOffset, yOffset + hoverState * h, w, h);
        } else {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, xOffset, yOffset + hoverState * h, this.field_146120_f / 2, h);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, xOffset + w - this.field_146120_f / 2, yOffset + hoverState * h, this.field_146120_f / 2, h);
        }
        this.func_146119_b(minecraft, mouseX, mouseY);
        this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.getWidth() / 2, this.field_146129_i + (h - 8) / 2, this.getTextColor(mouseOver));
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return this.toolTip;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.field_146125_m;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }
}

