/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosomeType;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.apiculture.flowers.FlowerProvider;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.genetics.alleles.AlleleInteger;
import forestry.core.genetics.alleles.AlleleTolerance;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleHelper;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;

public class AlleleHelper
implements IAlleleHelper {
    private static final String modId = "forestry";
    @Nullable
    private static AlleleHelper instance;
    private final Map<Class, Map<?, ? extends IAllele>> alleleMaps = new HashMap();

    public static AlleleHelper getInstance() {
        if (instance == null) {
            instance = new AlleleHelper();
        }
        return instance;
    }

    public void init() {
        if (ForestryAPI.enabledModules.contains(new ResourceLocation(modId, "apiculture"))) {
            this.createAlleles(EnumAllele.Fertility.class, EnumBeeChromosome.FERTILITY);
            this.createAlleles(EnumAllele.Flowering.class, EnumBeeChromosome.FLOWERING);
            this.createAlleles(EnumAllele.Territory.class, EnumBeeChromosome.TERRITORY);
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation(modId, "apiculture")) || ForestryAPI.enabledModules.contains(new ResourceLocation(modId, "lepidopterology"))) {
            this.createAlleles(EnumAllele.Speed.class, EnumBeeChromosome.SPEED, EnumButterflyChromosome.SPEED);
            this.createAlleles(EnumAllele.Lifespan.class, EnumBeeChromosome.LIFESPAN, EnumButterflyChromosome.LIFESPAN);
            this.createAlleles(EnumAllele.Tolerance.class, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumButterflyChromosome.TEMPERATURE_TOLERANCE, EnumButterflyChromosome.HUMIDITY_TOLERANCE);
            this.createAlleles(EnumAllele.Flowers.class, EnumBeeChromosome.FLOWER_PROVIDER, EnumButterflyChromosome.FLOWER_PROVIDER);
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation(modId, "arboriculture"))) {
            this.createAlleles(EnumAllele.Height.class, EnumTreeChromosome.HEIGHT);
            this.createAlleles(EnumAllele.Saplings.class, EnumTreeChromosome.FERTILITY);
            this.createAlleles(EnumAllele.Yield.class, EnumTreeChromosome.YIELD);
            this.createAlleles(EnumAllele.Fireproof.class, EnumTreeChromosome.FIREPROOF);
            this.createAlleles(EnumAllele.Maturation.class, EnumTreeChromosome.MATURATION);
            this.createAlleles(EnumAllele.Sappiness.class, EnumTreeChromosome.SAPPINESS);
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation(modId, "lepidopterology"))) {
            this.createAlleles(EnumAllele.Size.class, EnumButterflyChromosome.SIZE);
        }
        HashMap<Integer, AlleleInteger> integers = new HashMap<Integer, AlleleInteger>();
        for (int i = 1; i <= 10; ++i) {
            AlleleInteger alleleInteger = new AlleleInteger(modId, "i", i + "d", i, true);
            AlleleManager.alleleRegistry.registerAllele(alleleInteger, EnumTreeChromosome.GIRTH, EnumButterflyChromosome.METABOLISM, EnumButterflyChromosome.FERTILITY);
            integers.put(i, alleleInteger);
        }
        this.alleleMaps.put(Integer.class, integers);
        HashMap<Boolean, AlleleBoolean> booleans = new HashMap<Boolean, AlleleBoolean>();
        booleans.put(true, new AlleleBoolean(modId, "bool", true, false));
        booleans.put(false, new AlleleBoolean(modId, "bool", false, false));
        for (IAlleleBoolean alleleBoolean : booleans.values()) {
            AlleleManager.alleleRegistry.registerAllele(alleleBoolean, EnumBeeChromosome.NEVER_SLEEPS, EnumBeeChromosome.TOLERATES_RAIN, EnumBeeChromosome.CAVE_DWELLING, EnumButterflyChromosome.NOCTURNAL, EnumButterflyChromosome.TOLERANT_FLYER, EnumButterflyChromosome.FIRE_RESIST);
        }
        this.alleleMaps.put(Boolean.class, booleans);
    }

    private IAllele get(Object value) {
        Class<?> valueClass = value.getClass();
        Map<?, IAllele> map = this.alleleMaps.get(valueClass);
        if (map == null) {
            throw new IllegalArgumentException("There is no IAllele type for: " + valueClass + ' ' + value);
        }
        IAllele allele = map.get(value);
        if (allele == null) {
            throw new IllegalArgumentException("There is no IAllele for: " + valueClass + ' ' + value);
        }
        return allele;
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAllele allele) {
        if (!((IChromosomeType)((Object)chromosomeType)).getAlleleClass().isInstance(allele)) {
            throw new IllegalArgumentException("Allele is the wrong type. Expected: " + chromosomeType + " Got: " + allele);
        }
        Collection<IChromosomeType> validTypes = AlleleManager.alleleRegistry.getChromosomeTypes(allele);
        if (validTypes.size() > 0 && !validTypes.contains(chromosomeType)) {
            throw new IllegalArgumentException("Allele can't applied to this Chromosome type. Expected: " + validTypes + " Got: " + chromosomeType);
        }
        alleles[chromosomeType.ordinal()] = allele;
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, IAlleleValue value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, boolean value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    @Override
    public <T extends Enum<T>> void set(IAllele[] alleles, T chromosomeType, int value) {
        this.set(alleles, chromosomeType, this.get(value));
    }

    private <K extends Enum<K>, V> void createAlleles(Class<K> enumClass, IChromosomeType ... types) {
        String category = enumClass.getSimpleName().toLowerCase(Locale.ENGLISH);
        EnumMap<Enum, IAllele> map = new EnumMap<Enum, IAllele>(enumClass);
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            IAllele allele = AlleleHelper.createAllele(category, (IAlleleValue)((Object)enumValue), types);
            map.put(enumValue, allele);
        }
        this.alleleMaps.put(enumClass, map);
    }

    private static <K extends IAlleleValue<V>, V> IAllele createAllele(String category, K enumValue, IChromosomeType ... types) {
        V value = enumValue.getValue();
        boolean isDominant = enumValue.isDominant();
        String name = enumValue.toString().toLowerCase(Locale.ENGLISH);
        Class<?> valueClass = value.getClass();
        if (Float.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFloat(modId, category, name, ((Float)value).floatValue(), isDominant, types);
        }
        if (Integer.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createInteger(modId, category, name, (Integer)value, isDominant, types);
        }
        if (Vec3i.class.isAssignableFrom(valueClass)) {
            Vec3i area = (Vec3i)value;
            return AlleleManager.alleleFactory.createArea(modId, category, name, area, isDominant, types);
        }
        if (Boolean.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createBoolean(modId, category, (Boolean)value, isDominant, types);
        }
        if (EnumTolerance.class.isAssignableFrom(valueClass)) {
            AlleleTolerance alleleTolerance = new AlleleTolerance(modId, category, name, (EnumTolerance)((Object)value), isDominant);
            AlleleManager.alleleRegistry.registerAllele(alleleTolerance, types);
            return alleleTolerance;
        }
        if (FlowerProvider.class.isAssignableFrom(valueClass)) {
            return AlleleManager.alleleFactory.createFlowers(modId, category, name, (FlowerProvider)value, isDominant, types);
        }
        throw new RuntimeException("could not create allele for category: " + category + " and value " + valueClass);
    }
}

