/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class PipetteContents {
    private final FluidStack contents;

    @Nullable
    public static PipetteContents create(ItemStack itemStack) {
        FluidStack contents = FluidUtil.getFluidContained((ItemStack)itemStack);
        if (contents == null) {
            return null;
        }
        return new PipetteContents(contents);
    }

    public PipetteContents(FluidStack contents) {
        this.contents = contents;
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public boolean isFull() {
        return this.contents.amount >= 1000;
    }

    public void addTooltip(List<String> list) {
        String descr = this.contents.getFluid().getLocalizedName(this.contents);
        descr = descr + " (" + this.contents.amount + " mb)";
        list.add(descr);
    }
}

